/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZJobCA7InputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.workspace.model.segments.EZSourceJobCA7IDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CA7JobPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "select CA7_Jobs.JobID, CA7_Jobs.JOB_NAME, CA7_Jobs.JCL_MEMBER, CA7_Libraries.DSN from CA7_Jobs \n\tinner join CA7_Libraries on CA7_Libraries.LibID = CA7_Jobs.LibID  @1@";
    private String countQuery = "select count(CA7_Jobs.JobID) from CA7_Jobs @1@";

    public CA7JobPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    @Override
    public AnalysisType getOperationType() {
        return AnalysisType.EZSOURCE_CA7_GRAPH_ANALYSIS;
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IMFProjectHandler getProjectHandler() {
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(this.project, null);
        return ph;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "CA7_Jobs.JOB_NAME", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(CA7JobPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where CA7_Jobs.JOB_NAME");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZJobCA7InputType> inputs = new ArrayList<EZJobCA7InputType>();
        String jobId = null;
        String jobName = null;
        String memberName = null;
        String libName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            jobId = row[2];
            jobName = row[3];
            memberName = row[4];
            libName = row[5];
            EZJobCA7InputType inputType = new EZJobCA7InputType();
            inputs.add(inputType);
            EZSourceJobCA7IDSg jobSg = new EZSourceJobCA7IDSg(jobName, Integer.valueOf(jobId), memberName);
            jobSg.setLibraryName(libName);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)jobSg);
            inputType.setEntID(entityId);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String jobName = null;
        String memberName = null;
        String libName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            jobName = row[3];
            memberName = row[4];
            libName = row[5];
            break;
        }
        if (jobName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(CA7JobPaginatedHandler.class, "properties.name.label"), jobName});
            node.addRow(new String[]{Messages.getString(CA7JobPaginatedHandler.class, "properties.memberName.label"), memberName != null ? memberName : ""});
            node.addRow(new String[]{Messages.getString(CA7JobPaginatedHandler.class, "properties.libraryName.label"), libName != null ? libName : ""});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }
}

