/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.AnnotationsDbCheckerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotatedPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AnnotatedPaginatedHandler.class);
    protected static final String ANN_COLUMN_MARKER = "@@@@@EZLEGACY_ANN@@@@";
    private static final String RESTYPE_MARKER = "@@@@@EZLEGACY_RESTYPE@@@@";
    protected String annBaseQ = "select \n@@@@@EZLEGACY_ANN@@@@ from AnnDetail det \ninner join Annotation ann on ann.id=det.annId and ann.deleted=0 \ninner join Resource as res on res.annResID=det.annResID and res.projectinfo=det.project \nwhere det.k='resource' and det.resType=@@@@@EZLEGACY_RESTYPE@@@@ and det.project=?";
    protected static final String ANN_DETAIL_RES_NAME_RESTRICT = " and UPPER(det.resName) ";
    protected static final String ANN_COUNT_RES_COLUMN = "count (distinct res.dbid)";
    protected static final String ANN_RESID_COLUMN = "distinct res.dbid";
    private Boolean annDBAvailable = null;
    protected int resType = -1;
    protected int resIdColumn = -1;
    protected int annotationcolum = -1;
    protected int pathColumn = -1;

    public AnnotatedPaginatedHandler(ProjectInfo pi) {
        super(pi);
        this.acceptAnnotations = true;
    }

    protected void init() {
        this.info.put("dbIdColumn", this.resIdColumn);
        this.info.put("annotationColumn", this.annotationcolum);
        this.info.put("pathColumn", this.pathColumn);
        this.info.put("resType", String.valueOf(this.resType));
        this.info.put("acceptAnnotations", this.acceptAnnotations);
        this.info.put("dcColumn", 8);
        this.annBaseQ = this.annBaseQ.replaceAll(RESTYPE_MARKER, String.valueOf(this.resType));
    }

    protected boolean isAnnDbAvailable() {
        if (this.annDBAvailable == null) {
            AnnotationsDbCheckerService srv = (AnnotationsDbCheckerService)ServiceUtils.getService(AnnotationsDbCheckerService.class);
            if (srv != null) {
                this.annDBAvailable = srv.isAnnDbAvailable();
            } else {
                L.trace("AnnotationsDbCheckerService not found!");
                this.annDBAvailable = null;
            }
        }
        return this.annDBAvailable != null ? this.annDBAvailable : false;
    }

    protected String prepareAnnBaseQuery(boolean annDBAvailable, String annReplacement) {
        String query = this.getAnnotBaseQuery();
        query = query.replaceAll(ANN_COLUMN_MARKER, annReplacement);
        return query;
    }

    protected String getAnnotBaseQuery() {
        return this.annBaseQ;
    }

    @Override
    public boolean acceptAnnotations() {
        if (!this.isAnnDbAvailable()) {
            this.acceptAnnotations = false;
        }
        return this.acceptAnnotations;
    }

    protected boolean countInPrjRepo(ISQLFilter filter, boolean annDBAvailable) {
        return filter == null || !filter.considerAnnotations() || !annDBAvailable;
    }
}

