/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;

public class AdsMapPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "select AdsMaps.MapID, AdsMaps.MapName, ADsMaps.OccurID, Paths.PathStr as path from AdsMaps\n\tleft join Occurrences on Occurrences.OccurID = AdsMaps.OccurId\n\tleft join Paths on Paths.PathID = Occurrences.PathID  @1@";
    private String countQuery = "SELECT count(AdsMaps.MapID) from AdsMaps  @1@";

    public AdsMapPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "AdsMaps.MapName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(AdsMapPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where AdsMaps.MapName");
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        if (rowObject.length >= 6) {
            path = rowObject[5];
        }
        if (path != null) {
            this.openEditor(10095, path, null, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(AdsMapPaginatedHandler.class, "noSource.typeName"), rowObject[1]);
        }
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        Integer screenID = null;
        String screenName = null;
        String screenOccur = null;
        for (String[] row : selection) {
            if (row == null) continue;
            screenID = Integer.valueOf(row[2]);
            screenName = row[3];
            screenOccur = row[4];
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            EZSourceScreenIDSg scrIdSg = new EZSourceScreenIDSg(screenID, screenName, 118, Integer.valueOf(screenOccur));
            entity.addSegment((EZSegment)scrIdSg);
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(95), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            inputType.setName(screenName);
            inputType.setEntID(entity);
            inputs.add(inputType);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String screenName = null;
        String path = null;
        for (String[] row : selection) {
            if (row == null) continue;
            screenName = row[3];
            path = row[5];
            break;
        }
        if (screenName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(AdsMapPaginatedHandler.class, "properties.name.label"), screenName});
            node.addRow(new String[]{Messages.getString(AdsMapPaginatedHandler.class, "properties.path.label"), path != null ? path : ""});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }
}

