/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandlerWithFilterInBrackets;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZSourceAdabasFile;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.AdabasUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceAdabasIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class AdabasFilePaginatedHandler
extends MFPaginatedHandlerWithFilterInBrackets {
    private String baseQuery = "SELECT FILEID, FNAME, DB from EZViewer_Adabas_View @1@ @2@";
    private String countQuery = "SELECT count(FileID) FROM  cacheEZViewer_Adabas_View @1@ @2@";

    public AdabasFilePaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "fName, db", start, end, filter);
        return new PagedRunnable(query, "EZViewer_Adabas_View");
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), "EZViewer_Adabas_View", new String[]{"1", Messages.getString(AdabasFilePaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where fName", " and db");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZSourceAdabasFile> inputs = new ArrayList<EZSourceAdabasFile>();
        String adabasName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            Integer dbId = new Integer(row[1]);
            adabasName = this.getListableNameFromRow(row);
            EZSourceAdabasFile inputType = new EZSourceAdabasFile();
            EZSourceAdabasIDSg adabasSg = new EZSourceAdabasIDSg(adabasName);
            adabasSg.setNumber(dbId.intValue());
            adabasSg.setFileName(this.getFileNameFromRow(row));
            adabasSg.setDbName(this.getDbNameFromRow(row));
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)adabasSg);
            inputType.setEntID(entityId);
            inputs.add(inputType);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    private String getListableNameFromRow(String[] row) {
        String adabFile = this.getFileNameFromRow(row);
        String dbName = this.getDbNameFromRow(row);
        return AdabasUtils.getListableName((String)adabFile, (String)dbName);
    }

    private String getFileNameFromRow(String[] row) {
        return row[2];
    }

    private String getDbNameFromRow(String[] row) {
        return row[3];
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String fileName = null;
        String dbName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            fileName = this.getFileNameFromRow(row);
            dbName = this.getDbNameFromRow(row);
            break;
        }
        if (fileName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(AdabasFilePaginatedHandler.class, "properties.filename.label"), fileName});
            node.addRow(new String[]{Messages.getString(AdabasFilePaginatedHandler.class, "properties.databasename.label"), dbName});
            node.addRow(new String[]{Messages.getString(AdabasFilePaginatedHandler.class, "properties.type.label"), Messages.getString(AdabasFilePaginatedHandler.class, "properties.type.value")});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }

    @Override
    public String getFilterTooltipText() {
        return null;
    }

    @Override
    protected Object prepareDataValue(int col, int line, String[] row) {
        String val = "";
        val = row == null ? Messages.getString(AdabasFilePaginatedHandler.class, "loadingData.message", new String[]{String.valueOf(line)}) : (row.length > 2 ? String.valueOf(val) + this.getListableNameFromRow(row) : row[1]);
        return val;
    }
}

