/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandlerWithFilterInBrackets;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.StringUtils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.AAUTONetworkIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;

public class AAUTONetworksPaginatedHandler
extends MFPaginatedHandlerWithFilterInBrackets {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int NETWORK_ID_COLUMN = 1;
    private static final int NETWORK_NAME_COLUMN = 2;
    private static final int NETWORK_EXPANDED_NAME_COLUMN = 3;
    private static final int NETWORK_PATH = 5;
    private String baseQuery = "SELECT AAUTONetworks.NetworkID, AAUTONetworks.NetworkName, AAUTONetworks.NetwkExpandedName, AAUTONetworks.Line, Paths.PathStr\nFROM         AAUTONetworks\n left join Occurrences on AAUTONetworks.OccurId = Occurrences.OccurID\n left join Paths on Paths.PathID = Occurrences.PathID @1@ @2@";
    private String countQuery = "SELECT count(AAUTONetworks.NetworkID) \nFROM         AAUTONetworks \n @1@ @2@";

    public AAUTONetworksPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    @Override
    public AnalysisType getOperationType() {
        return AnalysisType.EZSOURCE_AAUTO_GRAPH_ANALYSIS;
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "AAUTONetworks.NetworkName,AAUTONetworks.NetwkExpandedName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(AAUTONetworksPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where AAUTONetworks.NetworkName", " and AAUTONetworks.NetwkExpandedName");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String networkName = null;
        String networkExpandedName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            networkName = row[2];
            networkExpandedName = row[3];
            Integer networkId = Integer.valueOf(row[1]);
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(300), "EZ_OBJECT_TYPE_FOR_MAINFRAME");
            inputs.add(inputType);
            AAUTONetworkIDSg networkSg = new AAUTONetworkIDSg(networkId, networkName, networkExpandedName);
            inputType.setName(networkName);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)networkSg);
            inputType.setEntID(entityId);
            inputType.addProperty("mainframe resource id sg", (Object)networkSg);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        int startRow = 0;
        if (rowObject.length >= 6) {
            path = rowObject[5];
            startRow = Integer.valueOf(rowObject[4]) + 1;
        }
        if (path != null) {
            this.openEditor(300, path, new int[]{startRow}, this.pi.getName());
        } else if (rowObject.length >= 6) {
            this.reportNoSource(Messages.getString(AAUTONetworksPaginatedHandler.class, "noSource.typeName"), rowObject[2]);
        }
    }

    @Override
    protected Object prepareDataValue(int col, int line, String[] row) {
        String val = super.prepareDataValue(col, line, row).toString();
        if (row != null && row.length > 2) {
            val = row[2];
            String expandedName = StringUtils.empty2null((String)row[3]);
            expandedName = expandedName != null ? " (" + expandedName + ")" : "";
            val = String.valueOf(val) + expandedName;
        }
        return val;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String networkName = null;
        String expandedName = null;
        String path = null;
        for (String[] row : selection) {
            if (row == null) continue;
            networkName = row[2];
            expandedName = row[3];
            path = row[5];
            break;
        }
        MainframeGenericNode node = new MainframeGenericNode();
        node.addRow(new String[]{Messages.getString(AAUTONetworksPaginatedHandler.class, "properties.name.label"), networkName});
        node.addRow(new String[]{Messages.getString(AAUTONetworksPaginatedHandler.class, "properties.expandedName.label"), expandedName != null ? expandedName : ""});
        node.addRow(new String[]{Messages.getString(AAUTONetworksPaginatedHandler.class, "properties.type.label"), Messages.getString(AAUTONetworksPaginatedHandler.class, "properties.type.value")});
        node.addRow(new String[]{Messages.getString(AAUTONetworksPaginatedHandler.class, "properties.path.label"), path != null ? path : ""});
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)sg);
        return new StructuredSelection((Object)entID);
    }

    @Override
    public String getFilterTooltipText() {
        String tooktipText = Messages.getString(AAUTONetworksPaginatedHandler.class, "filter.textbox.tooltip");
        return tooktipText;
    }
}

