/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class AAUTOJobsPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "SELECT AAUTOJobs.JobID, AAUTOJobs.JobName \nFROM         AAUTOJobs  @1@";
    private String countQuery = "SELECT count(AAUTOJobs.JobID) \nFROM         AAUTOJobs  @1@";

    public AAUTOJobsPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    @Override
    public AnalysisType getOperationType() {
        return AnalysisType.EZSOURCE_AAUTO_GRAPH_ANALYSIS;
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "AAUTOJobs.JobName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(AAUTOJobsPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where AAUTOJobs.JobName");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String jobName = null;
        Integer jobID = null;
        for (String[] row : selection) {
            if (row == null) continue;
            jobName = row[3];
            jobID = Integer.valueOf(row[2]);
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(301), "EZ_OBJECT_TYPE_FOR_MAINFRAME");
            inputs.add(inputType);
            EZSourceAAUTOJobIDSg jobSg = new EZSourceAAUTOJobIDSg(jobName, jobID);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)jobSg);
            inputType.setEntID(entityId);
            inputType.addProperty("mainframe resource id sg", (Object)jobSg);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String jobName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            jobName = row[3];
            break;
        }
        MainframeGenericNode node = new MainframeGenericNode();
        node.addRow(new String[]{Messages.getString(AAUTOJobsPaginatedHandler.class, "properties.name.label"), jobName});
        node.addRow(new String[]{Messages.getString(AAUTOJobsPaginatedHandler.class, "properties.type.label"), Messages.getString(AAUTOJobsPaginatedHandler.class, "properties.type.value")});
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)sg);
        return new StructuredSelection((Object)entID);
    }
}

