/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl;

import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.mainframe.data.utils.Utils;

public class SQLFilter
implements ISQLFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String uiText;
    private boolean ascending;
    private boolean considerAnn = false;
    private boolean onlyDC = false;

    public SQLFilter(boolean ascending) {
        this.ascending = ascending;
    }

    public SQLFilter(boolean ascending, boolean considerAnn, boolean onlyDC) {
        this(ascending);
        this.considerAnn = considerAnn;
        this.onlyDC = onlyDC;
    }

    @Override
    public String getUIText() {
        return this.uiText;
    }

    @Override
    public void setUIText(String uiText) {
        this.uiText = uiText;
    }

    @Override
    public String getDBExpression() {
        return Utils.convertDbLikeValue((String)this.uiText, (boolean)false, (char)this.getEscapeChar());
    }

    @Override
    public String getLikeExpression() {
        String like = "";
        String dbExp = this.getDBExpression();
        if (!dbExp.trim().isEmpty()) {
            like = " like ( UPPER('" + dbExp + "')) ";
        }
        return like;
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.ascending ? 1231 : 1237);
        result = 31 * result + (this.considerAnn ? 1241 : 1247);
        result = 31 * result + (this.onlyDC ? 1251 : 1257);
        result = 31 * result + (this.uiText == null ? 0 : this.uiText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLFilter other = (SQLFilter)obj;
        if (this.ascending != other.ascending) {
            return false;
        }
        if (this.considerAnn != other.considerAnn) {
            return false;
        }
        if (this.onlyDC != other.onlyDC) {
            return false;
        }
        return !(this.uiText == null ? other.uiText != null : !this.uiText.equalsIgnoreCase(other.uiText));
    }

    @Override
    public boolean considerAnnotations() {
        return this.considerAnn;
    }

    @Override
    public boolean onlyDC() {
        return this.onlyDC;
    }
}

