/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl;

import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.mainframe.data.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedRunnable
implements IPagedRunnable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PagedRunnable.class);
    protected Map<Integer, String[]> results = new HashMap<Integer, String[]>();
    private String query;
    private String viewName;
    private Object[] params = null;

    public PagedRunnable(String query, String viewName) {
        this(query);
        this.viewName = viewName;
    }

    public PagedRunnable(String query) {
        this.query = query;
    }

    public void setQueryParams(Object[] params) {
        this.params = params;
    }

    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
        boolean preparedCache;
        this.results.clear();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)500);
        boolean bl = preparedCache = this.viewName == null;
        if (!preparedCache) {
            preparedCache = Utils.prepareCache((EZSourceConnection)conn, (String)this.viewName, (IProgressMonitor)monitor.newChild(100));
        }
        if (!preparedCache) {
            L.warn("Cache already in progress. Retry later.");
            return;
        }
        String[][] rez = null;
        rez = this.params == null ? conn.executeSQL(this.query) : conn.executeSQL(this.query, this.params);
        if (rez != null) {
            String project = conn.getProjectInfo().getProjectName();
            this.prepareResults(project, rez);
        } else {
            L.info("NULL result for query: {}", (Object)this.query);
        }
    }

    protected void prepareResults(String project, String[][] rez) {
        int i = 0;
        while (i < rez.length) {
            this.results.put(Integer.valueOf(rez[i][0]), rez[i]);
            ++i;
        }
    }

    @Override
    public Map<Integer, String[]> getResults() {
        return this.results;
    }
}

