/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl;

import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.SQLFilter;
import com.ez.mainframe.model.ProjectInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MFPaginatedHandlerWithFilterInBrackets
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public MFPaginatedHandlerWithFilterInBrackets(ProjectInfo pi) {
        super(pi);
    }

    @Override
    protected String paginate(String query, String partitionColumn, int start, int end, ISQLFilter filter) {
        String order = filter == null ? "asc" : (filter.isAscending() ? "asc" : "desc");
        StringBuilder sb = new StringBuilder();
        if ((query = query.trim()).toLowerCase().startsWith("select")) {
            query = query.substring("select".length());
        }
        sb.append("select t.* from \n");
        sb.append("\t (select ROW_NUMBER() OVER( ORDER BY ").append(partitionColumn.replaceAll(",", " " + order + " ,"));
        sb.append(" ").append(order).append(") as RNUMBER, \n");
        sb.append(query).append("\n");
        sb.append("\n ) as t \twhere t.RNUMBER >= ").append(start).append(" and t.RNUMBER <= ").append(end);
        return sb.toString();
    }

    protected Object[][] getParamObjects(ISQLFilter filter, String prefix1, String prefix2) {
        String datasetMemberName;
        String datasetName;
        String val = filter == null ? "" : filter.getUIText().trim();
        String patternString = "(.*)(?<!\\\\)\\((.*)\\)";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(val);
        if (matcher.matches()) {
            datasetName = val.replaceAll(patternString, "$1").trim();
            datasetMemberName = val.replaceAll(patternString, "$2").trim();
        } else {
            datasetName = val;
            datasetMemberName = "";
        }
        boolean asc = filter == null ? Boolean.TRUE.booleanValue() : filter.isAscending();
        SQLFilter datasetNameSqlFilter = new SQLFilter(asc){

            @Override
            public String getLikeExpression() {
                String like = "";
                String dbExp = this.getDBExpression();
                String dbExpTrimmed = dbExp.trim();
                if (dbExpTrimmed.isEmpty()) {
                    dbExpTrimmed = "%";
                }
                like = " like ('" + dbExpTrimmed + "') ";
                return like;
            }
        };
        datasetNameSqlFilter.setUIText(datasetName);
        SQLFilter datasetMemberNameSqlFilter = new SQLFilter(asc);
        datasetMemberNameSqlFilter.setUIText(datasetMemberName);
        return new Object[][]{this.getParamObject(datasetNameSqlFilter.getLikeExpression(), prefix1), this.getParamObject(datasetMemberNameSqlFilter.getLikeExpression(), prefix2)};
    }

    @Override
    public abstract String getFilterTooltipText();
}

