/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl;

import com.ez.analysis.mainframe.explore.data.IContextReporter;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.AbstractPaginatedHandler;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MFPaginatedHandler
extends AbstractPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MFPaginatedHandler.class);
    protected ProjectInfo pi;
    protected String project;
    private IContextReporter contextReporter;
    protected boolean prefDC = PreferenceUtils.getPreferenceStore().getBoolean("displayDeadCode");
    protected static String MARKER_1 = "MARKER_1";
    protected static String MARKER_2 = "MARKER_2";
    protected static final String dcQueryPart = " join (Select DISTINCT ResourceID, UnreachablePara from StatementReference \r\n\tinner join  OccurrencesStmt oc_stmt on oc_stmt.OccurID = StatementReference.OccurID\r\n\tinner join Paragraphs on UnreachablePara = -1 and Paragraphs.ParaID = oc_stmt.ParaID \r\n\twhere StatementReference.ResourceType = MARKER_1 ) as p on p.ResourceID = MARKER_2\n";

    public MFPaginatedHandler(ProjectInfo pi) {
        this.pi = pi;
        this.project = pi.getName();
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        L.debug("double click on {}: {}", (Object)row, Arrays.asList(rowObject));
    }

    @Override
    public IMenuItemProvider contributeContextMenu() {
        return null;
    }

    @Override
    public void setContextReporter(IContextReporter contextReporter) {
        this.contextReporter = contextReporter;
    }

    protected void setContextData(Map<String, Object> contextData) {
        this.contextReporter.reportContextData(contextData);
    }

    @Override
    public void handleSelection(IStructuredSelection selection) {
        if (!selection.isEmpty() && selection.getFirstElement() != null) {
            StructuredSelection sel = null;
            Map<String, Object> data = null;
            String[] row = (String[])selection.getFirstElement();
            if (row.length > 2 && (data = this.prepareContextData(selection)) != null) {
                data.put("tableSelection", selection);
                sel = this.prepareSelection4Properties(selection);
                data.put("unique identifier of the property sheet page contributor", "ezselection.contributor");
            }
            if (sel == null) {
                sel = new StructuredSelection();
            }
            if (data == null) {
                data = new HashMap<String, Object>();
            }
            data.put("selection", sel);
            this.setContextData(data);
        }
    }

    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        return null;
    }

    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        return null;
    }

    protected void openEditor(int type, String path, int[] bounds, String project) {
        this.openEditor(Integer.toString(type), path, bounds, project);
    }

    protected void openEditor(String type, final String path, final int[] bounds, final String project) {
        final String editorId = Utils.getEditorId((String)type);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Utils.openEditor((String)path, (int[])bounds, (String)editorId, (String)project);
            }
        });
    }

    @Override
    protected Object prepareDataValue(int col, int line, String[] row) {
        String val = "";
        if (col == 0) {
            val = row == null ? Messages.getString(MFPaginatedHandler.class, "loadingData.message", new String[]{String.valueOf(line)}) : row[1];
        } else if (row != null) {
            val = row[4];
        }
        return val;
    }

    @Override
    public String getProjectName() {
        return this.project;
    }

    @Override
    protected IMFProjectHandler getProjectHandler() {
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(this.project, null);
        return ph;
    }

    protected String prepare(String query, Object[][] params) {
        int idx = 1;
        String rquery = query;
        Object[][] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] param = objectArray[n2];
            int type = (Integer)param[0];
            String form = "@" + idx + "@";
            String paramValue = Matcher.quoteReplacement(param[1].toString());
            switch (type) {
                case 0: 
                case 2: {
                    rquery = rquery.replaceAll(form, paramValue);
                    break;
                }
                case 1: {
                    rquery = rquery.replaceAll(form, "\"" + paramValue + "\"");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal argument type " + idx + " " + type);
                }
            }
            ++idx;
            ++n2;
        }
        return rquery;
    }

    protected String paginate(String query, String partitionColumn, int start, int end, ISQLFilter filter) {
        String order = filter == null ? "asc" : (filter.isAscending() ? "asc" : "desc");
        StringBuilder sb = new StringBuilder();
        if ((query = query.trim()).toLowerCase().startsWith("select")) {
            query = query.substring("select".length());
        }
        sb.append("select t.* from \n");
        sb.append("\t (select ROW_NUMBER() OVER( ORDER BY ").append(partitionColumn);
        sb.append(" ").append(order).append(") as RNUMBER, \n");
        sb.append("\t ").append(partitionColumn).append(" as LISTABLE_NAME, \n");
        sb.append(query).append("\n");
        sb.append("\n ) as t \twhere t.RNUMBER >= ").append(start).append(" and t.RNUMBER <= ").append(end);
        return sb.toString();
    }

    protected Object[][] getParamObjects(ISQLFilter filter, String prefix) {
        String like;
        String string = like = filter == null ? "" : filter.getLikeExpression();
        if (!like.trim().isEmpty()) {
            like = String.valueOf(like) + " ESCAPE " + "'" + filter.getEscapeChar() + "'";
        }
        return new Object[][]{this.getParamObject(like, prefix)};
    }

    protected Object[] getParamObject(String like, String prefix) {
        return new Object[]{2, like.isEmpty() ? "" : String.valueOf(prefix) + " " + like};
    }

    protected void reportNoSource(String type, String name) {
        MessageBox mb = new MessageBox(Display.getDefault().getActiveShell(), 40);
        mb.setText(Messages.getString(MFPaginatedHandler.class, "noSource.messageBox.title"));
        mb.setMessage(Messages.getString(MFPaginatedHandler.class, "noSource.messageBox.message", new String[]{type, name}));
        mb.open();
    }

    @Override
    public String getFilterTooltipText() {
        String tooktipText = Messages.getString(MFPaginatedHandler.class, "filter.textbox.tooltip");
        return tooktipText;
    }
}

