/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.mainframe.data.utils.Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterRunnable
implements ICounterRunnable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CounterRunnable.class);
    private int count = 0;
    private String query = null;
    private String[] noDataRow;
    private String viewName;
    private Object[] queryParams;

    public CounterRunnable(String countQuery, String[] noDataRow) {
        this.query = countQuery;
        this.noDataRow = noDataRow;
    }

    public CounterRunnable(String countQuery, String viewName, String[] noDataRow) {
        this(countQuery, noDataRow);
        this.viewName = viewName;
    }

    public void setQueryParams(Object[] queryParams) {
        this.queryParams = queryParams;
    }

    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
        boolean preparedCache;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
        boolean bl = preparedCache = this.viewName == null;
        if (!preparedCache) {
            preparedCache = Utils.prepareCache((EZSourceConnection)conn, (String)this.viewName, (IProgressMonitor)monitor.newChild(100));
        }
        if (!preparedCache) {
            L.warn("Cache already in progress. Retry later.");
            return;
        }
        String[][] rez = null;
        EZSourceConnection annConn = this.getAnnConnection();
        rez = annConn != null ? (this.queryParams != null ? annConn.executeSQL(this.query, this.queryParams) : annConn.executeSQL(this.query)) : (this.queryParams != null ? conn.executeSQL(this.query, this.queryParams) : conn.executeSQL(this.query));
        try {
            this.count = Integer.valueOf(rez[0][0]);
        }
        catch (NumberFormatException nfe) {
            this.count = 0;
            L.error("could not count data", (Throwable)nfe);
        }
        if (annConn != null) {
            this.releaseAnnConnection(annConn);
        }
    }

    protected void releaseAnnConnection(EZSourceConnection annConn) {
    }

    protected EZSourceConnection getAnnConnection() {
        return null;
    }

    @Override
    public String[] getNoDataRow() {
        return this.noDataRow;
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

