/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl;

import com.ez.analysis.mainframe.explore.Activator;
import com.ez.analysis.mainframe.explore.data.impl.AnnPagedRunnable;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.LogUtil;
import com.ibm.ad.ann.core.AnnotationsDBUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedCounterRunnable
extends CounterRunnable {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AnnotatedCounterRunnable.class);

    public AnnotatedCounterRunnable(String countQuery, String[] noDataRow) {
        super(countQuery, noDataRow);
    }

    @Override
    protected EZSourceConnection getAnnConnection() {
        EZSourceConnection c = null;
        try {
            DatabaseInfo annotsInfo = AnnotationsDBUtils.getAnnDbInfo();
            if (annotsInfo == null) {
                L.warn("no settings for annotations repo in CCS;  cannot continue");
                String msg = Messages.getString(AnnPagedRunnable.class, "noAnnDbInfo.warning");
                throw new RuntimeException(msg);
            }
            c = AnnotationsDBUtils.getInstance().getConnection(annotsInfo);
            if (c == null) {
                L.warn("cannot obtain a connection to annotations repository");
                LogUtil.log((int)2, (String)EZAnnotationDbManager.NO_ANN_DB_CONNECTION_WARNING_MSG, null, (Bundle)Activator.getDefault().getBundle());
            }
        }
        catch (Exception e) {
            L.error("could not  get annotated resources", (Throwable)e);
        }
        return c;
    }

    @Override
    protected void releaseAnnConnection(EZSourceConnection annConn) {
        AnnotationsDBUtils.getInstance().releaseEZSConnection(annConn);
    }
}

