/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl;

import com.ez.analysis.mainframe.explore.Activator;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.LogUtil;
import com.ibm.ad.ann.core.AnnotationsDBUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnPagedRunnable
extends PagedRunnable {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AnnPagedRunnable.class);
    String resQuery;
    String annQuery = null;
    boolean onlyAnnotated = false;
    int annCol = -1;

    public AnnPagedRunnable(String qRes, String qAnn, boolean onlyAnn, Integer annColumn) {
        super(qRes, null);
        this.resQuery = qRes;
        this.annQuery = qAnn;
        this.onlyAnnotated = onlyAnn;
        this.annCol = annColumn;
    }

    @Override
    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
        String[][] rez;
        this.results.clear();
        String projectName = conn.getProjectInfo().getProjectName();
        HashSet<String> annotatedResId = new HashSet<String>();
        if (this.annQuery != null) {
            this.fillAnnotsResources(annotatedResId, projectName);
        }
        ArrayList<EZSourceDataType> types = null;
        ArrayList<String> values = null;
        if (this.onlyAnnotated) {
            types = new ArrayList<EZSourceDataType>();
            int i = 0;
            while (i < annotatedResId.size()) {
                types.add(EZSourceDataType.Integer);
                ++i;
            }
            values = new ArrayList<String>(annotatedResId);
        }
        String[][] stringArray = rez = this.onlyAnnotated ? conn.executeSQL(this.resQuery, types, values) : conn.executeSQL(this.resQuery);
        if (rez != null) {
            int i = 0;
            while (i < rez.length) {
                String resId = rez[i][2];
                rez[i][this.annCol] = this.onlyAnnotated ? "true" : String.valueOf(annotatedResId.contains(resId));
                this.results.put(Integer.valueOf(rez[i][0]), rez[i]);
                ++i;
            }
        } else {
            L.info("NULL result for query: {}", (Object)this.resQuery);
        }
    }

    private void fillAnnotsResources(Set<String> annotatedResId, String projectName) {
        block13: {
            EZSourceConnection c = null;
            try {
                try {
                    DatabaseInfo annotsInfo = AnnotationsDBUtils.getAnnDbInfo();
                    if (annotsInfo == null) {
                        L.warn("no settings for annotations repo in CCS;  cannot continue");
                        String msg = Messages.getString(AnnPagedRunnable.class, "noAnnDbInfo.warning");
                        throw new RuntimeException(msg);
                    }
                    c = AnnotationsDBUtils.getInstance().getConnection(annotsInfo);
                    if (c != null) {
                        String[][] rez = c.executeSQL(this.annQuery, new Object[]{projectName});
                        if (rez != null && rez.length > 0) {
                            int i = 0;
                            while (i < rez.length) {
                                annotatedResId.add(rez[i][0]);
                                ++i;
                            }
                        }
                    } else {
                        L.warn("cannot obtain a connection to annotations repository");
                        LogUtil.log((int)2, (String)EZAnnotationDbManager.NO_ANN_DB_CONNECTION_WARNING_MSG, null, (Bundle)Activator.getDefault().getBundle());
                    }
                }
                catch (Exception e) {
                    L.error("could not  get annotated resources", (Throwable)e);
                    String msg = Messages.getString(AnnPagedRunnable.class, "filtering.errorMessage");
                    LogUtil.displayErrorMessage((Throwable)e, (String)msg, (Plugin)Activator.getDefault());
                    if (c != null) {
                        AnnotationsDBUtils.getInstance().releaseEZSConnection(c);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (c != null) {
                    AnnotationsDBUtils.getInstance().releaseEZSConnection(c);
                }
                throw throwable;
            }
            if (c != null) {
                AnnotationsDBUtils.getInstance().releaseEZSConnection(c);
            }
        }
        L.debug("ids of annotated resources: {}", annotatedResId);
    }
}

