/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.IPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.Refresher;
import com.ez.analysis.mainframe.explore.data.impl.SQLFilter;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.AnalysisType;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaginatedHandler
implements IPaginatedHandler<String[]> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractPaginatedHandler.class);
    private Map<Integer, String[]> buffer = Collections.synchronizedMap(new HashMap());
    private int max = 200;
    private int around = 50;
    private int left = 0;
    private int right = 0;
    private int cleft = 0;
    private int cright = 0;
    private Object lockRange = new Object();
    private Object sleeper = new Object();
    private Object filterLock = new Object();
    private boolean shouldFinish = false;
    private boolean paused = false;
    private boolean started = false;
    private boolean stopped = false;
    private int rowCount = 0;
    private boolean hasData = false;
    private ISQLFilter filter;
    private boolean dirtyFilter = false;
    private boolean filterChanged = false;
    protected Map<String, Object> info = new HashMap<String, Object>();
    protected boolean acceptAnnotations = false;
    public static final String SELECTION_KEY = "selection";
    public static final String TABLE_SELECTION_KEY = "tableSelection";

    protected abstract IMFProjectHandler getProjectHandler();

    public abstract String getProjectName();

    protected abstract IPagedRunnable newPagedRunnable(ISQLFilter var1, int var2, int var3);

    protected abstract ICounterRunnable newCounterRunnable(ISQLFilter var1);

    protected abstract Object prepareDataValue(int var1, int var2, String[] var3);

    protected IMFRunnable newInitializerRunnable() {
        return null;
    }

    public AnalysisType getOperationType() {
        return null;
    }

    public void start(final Refresher refresher) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean shouldRefresh = false;
                IMFProjectHandler ph = AbstractPaginatedHandler.this.getProjectHandler();
                IPagedRunnable what = null;
                int queryStart = -1;
                int queryEnd = -1;
                int removeStart = -1;
                int removeEnd = -1;
                int workingStart = -1;
                int workingEnd = -1;
                boolean mustQuery = false;
                Future f = null;
                AbstractPaginatedHandler.this.rowCount = 0;
                ISQLFilter cfilter = null;
                int timeout = 10;
                Exception error = null;
                Object object = AbstractPaginatedHandler.this.filterLock;
                synchronized (object) {
                    cfilter = AbstractPaginatedHandler.this.filter;
                    AbstractPaginatedHandler.this.doInitialize(ph);
                    error = AbstractPaginatedHandler.this.countItems(refresher, ph, cfilter);
                }
                AbstractPaginatedHandler.this.started = true;
                while (AbstractPaginatedHandler.this.rowCount != -1 && !AbstractPaginatedHandler.this.shouldFinish) {
                    shouldRefresh = false;
                    queryStart = -1;
                    queryEnd = -1;
                    mustQuery = false;
                    object = AbstractPaginatedHandler.this.sleeper;
                    synchronized (object) {
                        if (AbstractPaginatedHandler.this.paused) {
                            L.debug("paused!");
                            try {
                                AbstractPaginatedHandler.this.sleeper.wait();
                            }
                            catch (InterruptedException ex) {
                                L.debug("interrupted ", (Throwable)ex);
                            }
                            L.debug("resumed");
                            refresher.run(null);
                            continue;
                        }
                    }
                    object = AbstractPaginatedHandler.this.filterLock;
                    synchronized (object) {
                        if (AbstractPaginatedHandler.this.filterChanged) {
                            cfilter = AbstractPaginatedHandler.this.filter;
                            if (AbstractPaginatedHandler.this.dirtyFilter) {
                                error = AbstractPaginatedHandler.this.countItems(refresher, ph, cfilter);
                                AbstractPaginatedHandler.this.dirtyFilter = false;
                            }
                            AbstractPaginatedHandler.this.filterChanged = false;
                            mustQuery = true;
                        }
                    }
                    object = AbstractPaginatedHandler.this.lockRange;
                    synchronized (object) {
                        if (AbstractPaginatedHandler.this.cleft != AbstractPaginatedHandler.this.left || AbstractPaginatedHandler.this.cright != AbstractPaginatedHandler.this.right) {
                            L.debug("current {}:{}; old {}:{}", new Object[]{AbstractPaginatedHandler.this.cleft, AbstractPaginatedHandler.this.cright, AbstractPaginatedHandler.this.left, AbstractPaginatedHandler.this.right});
                            if (AbstractPaginatedHandler.this.cleft < AbstractPaginatedHandler.this.left) {
                                queryStart = AbstractPaginatedHandler.this.cleft;
                                queryEnd = Math.min(AbstractPaginatedHandler.this.cright, AbstractPaginatedHandler.this.left);
                                removeStart = Math.max(AbstractPaginatedHandler.this.cright + 1, AbstractPaginatedHandler.this.left);
                                removeEnd = AbstractPaginatedHandler.this.right;
                            }
                            if (AbstractPaginatedHandler.this.cright > AbstractPaginatedHandler.this.right) {
                                queryStart = Math.max(AbstractPaginatedHandler.this.cleft, AbstractPaginatedHandler.this.right);
                                queryEnd = AbstractPaginatedHandler.this.cright;
                                removeStart = AbstractPaginatedHandler.this.left;
                                removeEnd = Math.min(AbstractPaginatedHandler.this.cleft - 1, AbstractPaginatedHandler.this.right);
                            }
                            workingStart = AbstractPaginatedHandler.this.cleft;
                            workingEnd = AbstractPaginatedHandler.this.cright;
                        }
                    }
                    if (queryStart == -1 && mustQuery) {
                        queryStart = AbstractPaginatedHandler.this.left;
                        queryEnd = AbstractPaginatedHandler.this.right;
                    }
                    if (queryStart != -1 && AbstractPaginatedHandler.this.hasData) {
                        if (f != null) {
                            L.debug("canceling {}:{}", (Object)AbstractPaginatedHandler.this.left, (Object)AbstractPaginatedHandler.this.right);
                            f.cancel(true);
                            what = null;
                        }
                        L.debug("querying {}:{}", (Object)queryStart, (Object)queryEnd);
                        try {
                            what = AbstractPaginatedHandler.this.newPagedRunnable(cfilter, queryStart, queryEnd);
                            long l = System.currentTimeMillis();
                            error = null;
                            ph.executeWithLock(ph, (IMFRunnable)what, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                            L.debug("return {}", (Object)(System.currentTimeMillis() - l));
                            L.debug("remove {}:{}", (Object)removeStart, (Object)removeEnd);
                            int i = removeStart;
                            while (i <= removeEnd) {
                                AbstractPaginatedHandler.this.buffer.remove(i);
                                ++i;
                            }
                            AbstractPaginatedHandler.this.buffer.putAll(what.getResults());
                            shouldRefresh = true;
                        }
                        catch (Exception ex) {
                            L.error("could not get data", (Throwable)ex);
                            error = ex;
                        }
                    }
                    AbstractPaginatedHandler.this.left = workingStart;
                    AbstractPaginatedHandler.this.right = workingEnd;
                    if (shouldRefresh || error != null) {
                        L.debug("should refresh");
                        refresher.run(error);
                        error = null;
                    }
                    object = AbstractPaginatedHandler.this.sleeper;
                    synchronized (object) {
                        try {
                            AbstractPaginatedHandler.this.sleeper.wait(timeout);
                        }
                        catch (InterruptedException ex) {
                            L.error("Error:", (Throwable)ex);
                        }
                    }
                }
                AbstractPaginatedHandler.this.buffer.clear();
                AbstractPaginatedHandler.this.stopped = true;
                L.debug("shuting down");
            }
        };
        t.setName("MFPaginatedDataProvider");
        t.start();
    }

    private Exception countItems(Refresher refresher, IMFProjectHandler ph, ISQLFilter filter) {
        Exception error = null;
        try {
            ICounterRunnable counter = this.newCounterRunnable(filter);
            ph.executeWithLock(ph, (IMFRunnable)counter, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
            this.rowCount = counter.getCount();
            this.hasData = true;
            if (this.rowCount == 0) {
                this.hasData = false;
                this.rowCount = 1;
                this.buffer.put(1, counter.getNoDataRow());
            }
            L.debug("updating rowcount");
            this.left = 0;
            this.right = this.hasData ? Math.min(this.max, this.rowCount) : 0;
            this.cleft = 0;
            this.cright = 0;
        }
        catch (Exception e) {
            this.hasData = false;
            error = e;
            L.error("could not count items", (Throwable)e);
        }
        refresher.run(error);
        return error;
    }

    public void clear() {
        this.buffer.clear();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        boolean isPaused = false;
        Object object = this.sleeper;
        synchronized (object) {
            isPaused = this.paused;
        }
        return isPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.sleeper;
        synchronized (object) {
            this.paused = true;
            this.sleeper.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.sleeper;
        synchronized (object) {
            this.paused = false;
            this.sleeper.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.onClose();
        this.shouldFinish = true;
        Object object = this.sleeper;
        synchronized (object) {
            this.sleeper.notifyAll();
        }
    }

    protected void onClose() {
    }

    public String[] getRowObject(int rowIndex) {
        int line = rowIndex + 1;
        String[] row = this.buffer.get(line);
        return row;
    }

    public int indexOfRowObject(String[] row) {
        return Integer.valueOf(row[0]) - 1;
    }

    public Object getDataValue(int col, int line) {
        String[] row = this.buffer.get(++line);
        Object value = this.prepareDataValue(col, line, row);
        this.adjustLimits(line);
        return value;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setDataValue(int arg0, int arg1, Object arg2) {
        throw new UnsupportedOperationException("setDataValue is not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustLimits(int line) {
        boolean force = false;
        Object object = this.lockRange;
        synchronized (object) {
            int rowCount = this.getRowCount();
            if (line > this.around && line < this.cleft + this.around || line < this.cleft) {
                this.cleft = Math.min(line, this.cleft) - this.around;
                this.cright = this.cleft + this.max;
                force = true;
            }
            if (line < rowCount - this.around && line > this.cright - this.around || line > this.cright) {
                this.cright = Math.max(line, this.cright) + this.around;
                this.cleft = this.cright - this.max;
                force = true;
            }
            if (this.cleft < 1) {
                this.cleft = 1;
                this.cright = this.cleft + this.max;
                force = true;
            }
            if (this.cright > rowCount) {
                this.cright = rowCount;
                this.cleft = this.cright - this.max;
                this.cleft = this.cleft < 1 ? 1 : this.cleft;
                force = true;
            }
        }
        if (force) {
            object = this.sleeper;
            synchronized (object) {
                L.debug("to update {}:{}#{}:{}", new Object[]{this.cleft, this.cright, this.left, this.right});
                this.sleeper.notify();
            }
        }
    }

    public void setFilter(ISQLFilter filter) {
        this.setFilter(filter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(ISQLFilter filter, boolean forceDirty) {
        Object object = this.filterLock;
        synchronized (object) {
            if (forceDirty || this.filter == null || !this.filter.equals(filter)) {
                this.dirtyFilter = true;
            }
            this.filterChanged = true;
            this.filter = filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISQLFilter getFilter() {
        Object object = this.filterLock;
        synchronized (object) {
            return this.filter;
        }
    }

    public boolean hasData() {
        return this.hasData;
    }

    public void createCustomArea(Composite customArea) {
    }

    private void doInitialize(IMFProjectHandler ph) {
        try {
            IMFRunnable runnable = this.newInitializerRunnable();
            if (runnable != null) {
                ph.executeWithLock(ph, runnable, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            L.error("could not count items", (Throwable)e);
        }
    }

    public ISQLFilter newFilter(boolean ascending, boolean considerAnn, boolean considerDC) {
        return new SQLFilter(ascending, considerAnn, considerDC);
    }

    public ISQLFilter newFilter(boolean ascending) {
        return this.newFilter(ascending, false, false);
    }

    public abstract String getFilterTooltipText();

    @Override
    public <T> T getInfo(String key) {
        return (T)this.info.get(key);
    }

    @Override
    public <T> T getBuffer() {
        return (T)this.buffer;
    }

    public boolean acceptAnnotations() {
        return this.acceptAnnotations;
    }

    public boolean acceptDeadCode() {
        return false;
    }
}

