/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.endevor.service;

import com.ez.internal.utils.LogUtil;
import com.ez.workspace.gotosource.ReceiveContentCallback;
import com.ibm.carma.request.CARMAConnectionNotConnectedException;
import com.ibm.carma.request.CARMANotSynchronizedException;
import com.ibm.carma.request.CARMARequestUtil;
import com.ibm.carma.request.CARMAUnsupportedOperationException;
import com.ibm.carma.request.model.CARMARepositoryConnection;
import com.ibm.carma.request.model.CARMARepositoryResource;
import com.ibm.carma.request.model.CARMAResourceActivityListener;
import com.ibm.carma.request.model.CARMAResourceEvent;
import com.ibm.ez.endevor.internal.Activator;
import com.ibm.ez.endevor.internal.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContentJob
extends Job {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RequestContentJob.class);
    private CARMARepositoryConnection carma = null;
    private ReceiveContentCallback rc = null;
    private Map<String, Properties> propMap = null;
    private CARMAResourceActivityListener listener;

    public RequestContentJob(CARMARepositoryConnection carma, Map<String, Properties> propMap, ReceiveContentCallback rc) {
        super(Messages.getString(RequestContentJob.class, "job.name"));
        this.carma = carma;
        this.propMap = new HashMap<String, Properties>(propMap);
        this.rc = rc;
    }

    protected IStatus run(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(100 * this.propMap.size()));
        monitor.setTaskName(Messages.getString(RequestContentJob.class, "task.name.parse"));
        for (Properties prop : this.propMap.values()) {
            if (monitor.isCanceled()) continue;
            this.makeRequest(prop, (IProgressMonitor)monitor.newChild(100));
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private void makeRequest(Properties prop, IProgressMonitor pmonitor) {
        String path = prop.getProperty("path");
        L.debug("start request job for {}", (Object)path);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(100 * this.propMap.size()));
        monitor.setTaskName(Messages.getString(RequestContentJob.class, "task.name.parse.path", new String[]{path}));
        RequestContentJob.extractDetailsFromPath(prop);
        String targetEnvironment = prop.getProperty("environment");
        String targetSystem = prop.getProperty("system");
        String targetSubSystem = prop.getProperty("subsystem");
        String stage = prop.getProperty("stage");
        String type = prop.getProperty("type");
        String elementName = prop.getProperty("element");
        String elementVersion = prop.getProperty("elm_version");
        String elementLevel = prop.getProperty("elm_level");
        monitor.worked(20);
        monitor.beginTask(Messages.getString(RequestContentJob.class, "task.name", new String[]{elementName}), 100);
        L.debug("environment: {} element name: {} targetSystem: {} targetSubSystem: {} stage: {}  type: {} elemVersion: {} elemLevel: {}", new Object[]{targetEnvironment, elementName, targetSystem, targetSubSystem, stage, type, elementVersion, elementLevel});
        try {
            try {
                CARMARepositoryResource resource = CARMARequestUtil.createCARMAMemberInstance((CARMARepositoryConnection)this.carma, (String)targetEnvironment, (String)targetSystem, (String)targetSubSystem, (String)stage, (String)type, (String)elementName, (String)elementVersion, (String)elementLevel);
                monitor.worked(50);
                if (resource != null) {
                    if (!monitor.isCanceled()) {
                        this.listener = new UpdateContentListener(resource, path);
                        resource.addCARMAResourceActivityListener(this.listener);
                        resource.extractContents();
                    } else {
                        this.rc.onErrorOrCancel();
                    }
                } else {
                    this.rc.onErrorOrCancel();
                    String msg = Messages.getString(RequestContentJob.class, "error.msg", new String[]{targetEnvironment, targetSystem, targetSubSystem, stage, type, elementName});
                    L.error("Error getting the element from the CA Endevor repository");
                    LogUtil.displayErrorMessage(null, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
                }
            }
            catch (OperationCanceledException ce) {
                this.rc.onErrorOrCancel();
                L.error("The processing was cancelled by user. {}", (Throwable)ce);
                String msg = Messages.getString(RequestContentJob.class, "cancel.msg.log", new Object[]{ce});
                LogUtil.displayErrorMessage(null, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
                monitor.done();
            }
            catch (CARMAConnectionNotConnectedException | CARMANotSynchronizedException | CARMAUnsupportedOperationException | InterruptedException | CoreException e) {
                this.rc.onErrorOrCancel();
                String msg = Messages.getString(RequestContentJob.class, "error.msg.ex", new Object[]{e});
                L.error("Error getting the element from the CA Endevor repository {}", (Object)e.getMessage());
                LogUtil.displayErrorMessage(null, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void extractDetailsFromPath(Properties prop) {
        String path = prop.getProperty("path");
        String[] info = path.substring(2).split("\\\\");
        String connectionIp = null;
        boolean foundLIBDir = false;
        boolean foundEndevor = false;
        boolean foundDetails = false;
        String[] connInfo = null;
        String elementName = null;
        String[] stringArray = info;
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String sg = stringArray[n2];
            if ("Mainframe Library Members".toUpperCase().equalsIgnoreCase(sg)) {
                foundLIBDir = true;
            } else if (foundLIBDir) {
                connectionIp = sg;
                foundLIBDir = false;
            } else if ("Endevor".toUpperCase().equalsIgnoreCase(sg)) {
                foundEndevor = true;
            } else if (!foundDetails && foundEndevor) {
                connInfo = sg.split("\\.");
                foundDetails = true;
            } else if (foundEndevor && foundDetails) {
                elementName = sg;
            }
            ++n2;
        }
        void targetEnvironment = connInfo[0];
        void targetSystem = connInfo[1];
        void targetSubSystem = connInfo[2];
        void stage = connInfo[4];
        void type = connInfo[3];
        prop.put("ip", connectionIp);
        prop.put("environment", (Object)targetEnvironment);
        prop.put("system", (Object)targetSystem);
        prop.put("subsystem", (Object)targetSubSystem);
        prop.put("type", (Object)type);
        prop.put("stage", (Object)stage);
        prop.put("element", elementName);
    }

    private final class UpdateContentListener
    implements CARMAResourceActivityListener {
        private CARMARepositoryResource resource;
        private String path;

        private UpdateContentListener(CARMARepositoryResource resource, String path) {
            this.resource = resource;
            this.path = path;
        }

        public void resourceContentsUpdated(CARMAResourceEvent e) {
            block16: {
                IFile contents = e.getContents();
                if (contents != null) {
                    L.debug("update Content for editor " + contents.getName());
                    InputStream is = null;
                    try {
                        try {
                            is = contents.getContents();
                            StringWriter writer = new StringWriter();
                            IOUtils.copy((InputStream)is, (Writer)writer, (String)contents.getCharset());
                            RequestContentJob.this.rc.receiveContent(this.path, contents, new StringBuilder(writer.getBuffer()));
                        }
                        catch (Exception ex) {
                            L.error("exception when convert content of the file {}", (Throwable)ex);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException io) {
                                    L.error("exception when try to close {}", (Throwable)io);
                                }
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException io) {
                                L.error("exception when try to close {}", (Throwable)io);
                            }
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException io) {
                            L.error("exception when try to close {}", (Throwable)io);
                        }
                    }
                } else {
                    RequestContentJob.this.rc.onErrorOrCancel();
                    L.warn("empty content");
                }
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (UpdateContentListener.this.resource != null) {
                        UpdateContentListener.this.resource.removeFilterView();
                        UpdateContentListener.this.resource.removeCARMAResourceActivityListener(RequestContentJob.this.listener);
                        RequestContentJob.this.listener = null;
                        UpdateContentListener.this.resource = null;
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }
}

