/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.endevor.service;

import com.ez.workspace.gotosource.IGoToSourceService;
import com.ez.workspace.gotosource.ReceiveContentCallback;
import com.ibm.carma.request.CARMARequestUtil;
import com.ibm.carma.request.model.CARMARepositoryConnection;
import com.ibm.ez.endevor.internal.Messages;
import com.ibm.ez.endevor.service.CarmaRepositoryDialog;
import com.ibm.ez.endevor.service.RequestContentJob;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndevorSourceServiceImpl
implements IGoToSourceService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EndevorSourceServiceImpl.class);
    private Map<String, Properties> propertiesMap = null;

    public boolean isEnableGoToSource(Map<String, Properties> propMap) {
        L.debug("start isEnableGoToSource");
        if (propMap == null) {
            return false;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String path : propMap.keySet()) {
            if (!path.toUpperCase().contains("\\" + "Mainframe Library Members".toUpperCase() + "\\") || !path.toUpperCase().contains("\\" + "Endevor".toUpperCase() + "\\")) {
                L.debug("file isn't retrieved from Endevor ", (Object)path);
                toRemove.add(path);
                continue;
            }
            L.debug("extract carma connection info from ", (Object)path);
            propMap.get(path).put("path", path);
        }
        propMap.keySet().removeAll(toRemove);
        this.propertiesMap = propMap;
        return this.propertiesMap.size() != 0;
    }

    public void openSource(ReceiveContentCallback rc, IProgressMonitor pmonitor) {
        if (pmonitor == null) {
            pmonitor = new NullProgressMonitor();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        boolean useDummy = Boolean.getBoolean("useDummy");
        if (useDummy) {
            Assert.isTrue((this.propertiesMap.size() == 1 ? 1 : 0) != 0);
            Properties properties = this.propertiesMap.values().iterator().next();
            RequestContentJob.extractDetailsFromPath(properties);
            Assert.isTrue((boolean)"SMPLTEST".equals(properties.getProperty("environment")));
            Assert.isTrue((boolean)"EZLPROJ".equals(properties.getProperty("system")));
            Assert.isTrue((boolean)"EZLITLS".equals(properties.getProperty("subsystem")));
            Assert.isTrue((boolean)"COBOLII".equals(properties.getProperty("type")));
            Assert.isTrue((boolean)"T".equals(properties.getProperty("stage")));
            Assert.isTrue((boolean)"programEndevor".equals(properties.getProperty("element")));
            rc.receiveContent(null, null, new StringBuilder("dummy content"));
        } else {
            List carmas = CARMARequestUtil.getCarmaConnections();
            ArrayList<CARMARepositoryConnection> connectedCarmas = new ArrayList<CARMARepositoryConnection>();
            CARMARepositoryConnection carma = null;
            for (CARMARepositoryConnection c : carmas) {
                if (!CARMARequestUtil.hasEndevorSCMRam((CARMARepositoryConnection)c)) continue;
                connectedCarmas.add(c);
            }
            monitor.worked(20);
            if (connectedCarmas.size() == 1) {
                carma = (CARMARepositoryConnection)connectedCarmas.get(0);
                L.debug("try to use carma connection {}", (Object)carma);
            } else {
                L.debug("no valid carma connection or multiple connections found");
                if (connectedCarmas.size() == 0) {
                    String dialogTitle = Messages.getString(EndevorSourceServiceImpl.class, "dialog.notconn.title");
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)dialogTitle, (String)Messages.getString(EndevorSourceServiceImpl.class, "no.conn.msg"));
                } else {
                    boolean ok;
                    String title = Messages.getString(EndevorSourceServiceImpl.class, "dialog.carmas.title");
                    CarmaRepositoryDialog dialog = new CarmaRepositoryDialog(Display.getDefault().getActiveShell(), title, carmas);
                    dialog.create();
                    boolean bl = ok = dialog.open() == 0;
                    if (ok) {
                        carma = dialog.getSelectedCarma();
                    }
                }
            }
            if (carma != null) {
                RequestContentJob job = new RequestContentJob(carma, this.propertiesMap, rc);
                job.schedule();
            } else {
                L.debug("carma not selected");
                rc.onErrorOrCancel();
            }
        }
    }

    public String getFileDetails(String path) {
        Properties prop = this.propertiesMap.get(path);
        String text = Messages.getString(EndevorSourceServiceImpl.class, "carma.detail", new Object[]{prop.get("element"), prop.get("ip"), prop.get("environment"), prop.get("system"), prop.get("subsystem"), prop.get("stage"), prop.get("type"), prop.get("elm_version"), prop.get("elm_level")});
        return text;
    }

    public String getQueryForVersion() {
        return "EZViewer_MFMemberInfo_Selective";
    }
}

