/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.endevor.service;

import com.ibm.carma.request.model.CARMARepositoryConnection;
import com.ibm.ez.endevor.internal.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CarmaRepositoryDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DIALOG_MIN_HEIGHT = 400;
    private static final int DIALOG_MIN_WIDTH = 300;
    private CARMARepositoryConnection carmaIdentif = null;
    private List<CARMARepositoryConnection> carmas = null;
    private String title;

    protected CarmaRepositoryDialog(Shell parentShell, String title, List<CARMARepositoryConnection> carmas) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.carmas = carmas;
        this.title = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.setHelpAvailable(false);
        newShell.setText(this.title);
        newShell.setMinimumSize(300, 400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.heightHint = 300;
        data.widthHint = 500;
        area.setLayoutData((Object)data);
        GridLayout gl = (GridLayout)area.getLayout();
        area.setLayout((Layout)gl);
        Label chooseCarmaLbl = new Label(area, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        chooseCarmaLbl.setLayoutData((Object)data);
        chooseCarmaLbl.setText(Messages.getString(CarmaRepositoryDialog.class, "chooseCarma.dialog.label"));
        org.eclipse.swt.widgets.List avList = new org.eclipse.swt.widgets.List(area, 2820);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        avList.setLayoutData((Object)data);
        int i = 0;
        for (CARMARepositoryConnection carma : this.carmas) {
            avList.add(carma.getIdentifier());
            avList.setData(carma.getIdentifier(), (Object)carma);
            if (i != 0) continue;
            this.carmaIdentif = carma;
            avList.select(i);
            ++i;
        }
        CarmaSelectionListener selectionListener = new CarmaSelectionListener();
        avList.addSelectionListener((SelectionListener)selectionListener);
        return area;
    }

    protected Control createButtonBar(Composite parent) {
        Control bb = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.carmaIdentif != null);
        return bb;
    }

    public CARMARepositoryConnection getSelectedCarma() {
        return this.carmaIdentif;
    }

    class CarmaSelectionListener
    extends SelectionAdapter {
        CarmaSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String[] sel = ((org.eclipse.swt.widgets.List)e.getSource()).getSelection();
            if (sel != null) {
                CarmaRepositoryDialog.this.carmaIdentif = (CARMARepositoryConnection)((org.eclipse.swt.widgets.List)e.getSource()).getData(sel[0]);
                CarmaRepositoryDialog.this.getButton(0).setEnabled(true);
            }
        }
    }
}

