/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.synchro.service.impl.vfile;

import com.ez.eclient.configuration.synchro.service.impl.vfile.OuputStreamImpl;
import com.ez.eclient.configuration.synchro.service.impl.vfile.VersionableFileException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class VersionableFile {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final int BUF_SIZE = 4096;
    public static final String BACKUP_SUFFIX = "~";
    private File file;
    private File backupFile;

    public VersionableFile(String filePath) {
        File file = new File(filePath);
        if (file.exists() && !file.isFile()) {
            throw new VersionableFileException(5, "Not a file: " + file, new Object[]{file});
        }
        this.file = file;
        this.backupFile = new File(String.valueOf(filePath) + BACKUP_SUFFIX);
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public boolean create() {
        try {
            return this.file.createNewFile();
        }
        catch (Exception exception) {
            throw new VersionableFileException(8, "Can't create: " + this.file, new Object[]{this.file});
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean hasBackup() {
        return this.backupFile.exists() && this.backupFile.isFile();
    }

    public void recoverBackup() {
        if (!this.backupFile.exists()) {
            throw new VersionableFileException(4, "File not found: " + this.backupFile, new Object[]{this.backupFile});
        }
        if (!this.backupFile.isFile()) {
            throw new VersionableFileException(5, "Not a file: " + this.backupFile, new Object[]{this.backupFile});
        }
        VersionableFile.copyFile(this.backupFile, this.file);
        if (!this.backupFile.delete()) {
            throw new VersionableFileException(3, "Can't delete file: " + this.backupFile, new Object[]{this.backupFile});
        }
    }

    public OutputStream createOutputStream() {
        return this.createOutputStream(false);
    }

    public OutputStream createOutputStream(boolean ignoreBackup) {
        OuputStreamImpl os;
        if (!ignoreBackup && this.hasBackup()) {
            throw new VersionableFileException(2, "File exists: " + this.backupFile, new Object[]{this.backupFile});
        }
        boolean hasBackup = false;
        if (this.file.exists()) {
            VersionableFile.backupFile(this.file, this.backupFile, null);
            hasBackup = true;
        }
        try {
            os = new OuputStreamImpl(this, this.file, hasBackup);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new VersionableFileException(4, "File not found: " + this.file, new Object[]{this.file});
        }
        return os;
    }

    void onStreamClosed(boolean hasBackup) {
        if (hasBackup && !this.backupFile.delete()) {
            throw new VersionableFileException(3, "Can't delete file: " + this.backupFile, new Object[]{this.backupFile});
        }
    }

    private static void backupFile(File file, File backupFile, String tmpSuffix) {
        File tmpFile;
        try {
            tmpFile = File.createTempFile(file.getName(), tmpSuffix, file.getParentFile());
        }
        catch (IOException e) {
            throw new VersionableFileException(8, "Can't create temporary file in directory", new Object[]{file.getParentFile()}, e);
        }
        VersionableFile.copyFile(file, tmpFile);
        if (!tmpFile.renameTo(backupFile)) {
            throw new VersionableFileException(9, "Can't rename file", new Object[]{tmpFile});
        }
    }

    private static void copyFile(File ifile, File ofile) {
        FileInputStream is;
        try {
            is = new FileInputStream(ifile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new VersionableFileException(6, "Can't read file: " + ifile, new Object[]{ifile});
        }
        try {
            FileOutputStream os;
            try {
                os = new FileOutputStream(ofile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new VersionableFileException(7, "Can't write file: " + ofile, new Object[]{ofile});
            }
            try {
                VersionableFile.copyStream(is, os, ifile, ofile);
            }
            finally {
                VersionableFile.close(os, ofile);
            }
        }
        finally {
            VersionableFile.close(is, ifile);
        }
    }

    private static void copyStream(FileInputStream input, FileOutputStream output, File ifile, File ofile) {
        byte[] buffer = new byte[4096];
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                try {
                    output.write(buffer, 0, n);
                }
                catch (Exception ex) {
                    throw new VersionableFileException(7, "Can't write file: " + ofile, new Object[]{ofile}, ex);
                }
            }
        }
        catch (IOException iOException) {
            throw new VersionableFileException(6, "Can't read file: " + ifile, new Object[]{ifile});
        }
        try {
            output.flush();
        }
        catch (IOException iOException) {
            throw new VersionableFileException(7, "Can't write file: " + ofile, new Object[]{ofile});
        }
    }

    private static void close(Closeable c, File file) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            throw new VersionableFileException(7, "Can't close file: " + file, new Object[]{file});
        }
    }
}

