/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.synchro.service.impl;

import com.ez.eclient.configuration.synchro.service.ConfigurationEvent;
import com.ez.eclient.configuration.synchro.service.ConfigurationListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventDispatcher {
    Logger L = LoggerFactory.getLogger(this.getClass());
    boolean run = false;
    LinkedList<ConfigurationEvent> queue = new LinkedList();
    Set<ConfigurationListener> globalListeners = new HashSet<ConfigurationListener>();
    Map<String, ConfigurationListener> listeners = new HashMap<String, ConfigurationListener>();

    public synchronized void start() {
        this.run = true;
    }

    public synchronized void registerListener(ConfigurationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener");
        }
        if (this.globalListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener already registered: " + listener);
        }
        this.globalListeners.add(listener);
    }

    public synchronized void registerListener(String uniqueId, ConfigurationListener listener) {
        if (uniqueId == null) {
            throw new IllegalArgumentException("uniqueId");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener");
        }
        ConfigurationListener l = this.listeners.get(uniqueId);
        if (l != null) {
            throw new IllegalArgumentException("Listener already registered: " + uniqueId);
        }
        this.listeners.put(uniqueId, listener);
    }

    public synchronized void unregisterListener(String uniqueId) {
        this.listeners.remove(uniqueId);
    }

    public synchronized void stop() {
        this.run = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addNotification(ConfigurationEvent n) {
        LinkedList<ConfigurationEvent> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(n);
        }
    }

    protected List<ConfigurationListener> findListener(String idQualifier) {
        LinkedList<ConfigurationListener> targets = new LinkedList<ConfigurationListener>();
        targets.addAll(this.globalListeners);
        for (Map.Entry<String, ConfigurationListener> le : this.listeners.entrySet()) {
            String k = le.getKey();
            if (k != idQualifier && !idQualifier.startsWith(String.valueOf(k) + ".")) continue;
            targets.add(le.getValue());
        }
        return targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClients() {
        LinkedList queueClone = null;
        if (this.L.isTraceEnabled()) {
            this.L.trace("Event dispatcher wake up...");
        }
        LinkedList<ConfigurationEvent> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.size() > 0) {
                queueClone = (LinkedList)this.queue.clone();
                this.queue.clear();
            }
        }
        if (queueClone != null) {
            HashMap<ConfigurationListener, LinkedList<ConfigurationEvent>> selectedListeners = new HashMap<ConfigurationListener, LinkedList<ConfigurationEvent>>();
            if (queueClone.size() > 0) {
                this.L.debug("Notifying changes...");
            }
            for (ConfigurationEvent configurationEvent : queueClone) {
                List<ConfigurationListener> ls = this.findListener(configurationEvent.getConfigurationDescription().getUniqueId());
                if (ls == null || ls.size() == 0) {
                    this.L.error("No listener registered for " + configurationEvent.getConfigurationDescription().getUniqueId());
                    continue;
                }
                for (ConfigurationListener l : ls) {
                    LinkedList<ConfigurationEvent> events = (LinkedList<ConfigurationEvent>)selectedListeners.get(l);
                    if (events == null) {
                        events = new LinkedList<ConfigurationEvent>();
                        selectedListeners.put(l, events);
                    }
                    events.add(configurationEvent);
                }
            }
            for (Map.Entry entry : selectedListeners.entrySet()) {
                ConfigurationListener l = (ConfigurationListener)entry.getKey();
                List el = (List)entry.getValue();
                try {
                    l.notifyEvent(Collections.unmodifiableList(el));
                }
                catch (Exception ex) {
                    this.L.error("Notification failed.", (Throwable)ex);
                }
            }
            if (queueClone.size() > 0) {
                this.L.debug("Notifying DONE.");
            }
        }
    }
}

