/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.synchro.service.impl;

import com.ez.eclient.configuration.synchro.service.impl.EventDispatcher;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventDispatcher
extends EventDispatcher {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static Logger L = LoggerFactory.getLogger(DefaultEventDispatcher.class);
    public static final String AC_CONFIG_SYNCHRO_START_DELAY = "AC_CONFIG_SYNCHRO_START_DELAY";
    public static final String AC_CONFIG_SYNCHRO_EVENT_DELAY = "AC_CONFIG_SYNCHRO_EVENT_DELAY";
    public static final long FIRST_DELAY_DEFAULT = 500L;
    public static final long DELAY_DEFAULT = 10000L;
    public static final long FIRST_DELAY = DefaultEventDispatcher.getSystemProperty("AC_CONFIG_SYNCHRO_START_DELAY", 500L);
    public static final long DELAY = DefaultEventDispatcher.getSystemProperty("AC_CONFIG_SYNCHRO_EVENT_DELAY", 10000L);
    Timer timer;
    boolean run = false;

    @Override
    public synchronized void start() {
        L.info("Starting...");
        L.info("FIRST_DELAY: {}", (Object)FIRST_DELAY);
        L.info("DELAY: {}", (Object)DELAY);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new Task(), FIRST_DELAY);
        super.start();
        L.info("Started.");
    }

    @Override
    public synchronized void stop() {
        try {
            if (this.run) {
                this.timer.cancel();
            }
        }
        finally {
            super.stop();
        }
    }

    private void run() {
        try {
            L.trace("Notification timer woke up.");
            this.notifyClients();
        }
        finally {
            this.timer.schedule((TimerTask)new Task(), DELAY);
        }
    }

    private static Long getSystemProperty(String key, Long defValue) {
        Long v;
        String sv = System.getProperty(key);
        if (sv == null) {
            v = defValue;
        } else {
            try {
                v = Long.parseLong(sv);
            }
            catch (Exception exception) {
                L.error("Can't parse integer system property {}={}", (Object)key, (Object)sv);
                v = defValue;
            }
        }
        return v;
    }

    class Task
    extends TimerTask {
        Task() {
        }

        @Override
        public void run() {
            DefaultEventDispatcher.this.run();
        }
    }
}

