/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.synchro.service.impl;

import com.ez.eclient.configuration.synchro.internal.Messages;
import com.ez.eclient.configuration.synchro.service.Configuration;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.ConfigurationEvent;
import com.ez.eclient.configuration.synchro.service.ConfigurationFormat;
import com.ez.eclient.configuration.synchro.service.ConfigurationListener;
import com.ez.eclient.configuration.synchro.service.ConfigurationSynchroService;
import com.ez.eclient.configuration.synchro.service.ConfigurationVersionChanged;
import com.ez.eclient.configuration.synchro.service.Constants;
import com.ez.eclient.configuration.synchro.service.DirectoryConfiguration;
import com.ez.eclient.configuration.synchro.service.EventType;
import com.ez.eclient.configuration.synchro.service.JsonConfiguration;
import com.ez.eclient.configuration.synchro.service.LogUtil;
import com.ez.eclient.configuration.synchro.service.PropertiesInterceptor;
import com.ez.eclient.configuration.synchro.service.SyncResolution;
import com.ez.eclient.configuration.synchro.service.impl.DefaultEventDispatcher;
import com.ez.eclient.configuration.synchro.service.impl.EventDispatcher;
import com.ez.eclient.configuration.synchro.service.impl.VersionablePropertiesReadonly;
import com.ez.eclient.configuration.synchro.service.impl.vfile.VersionableFile;
import com.ez.json.tools.converter.PropertiesConverter;
import com.ez.json.tools.validator.JsonValidator;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSynchroServiceImpl
implements ConfigurationSynchroService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static Logger L = LoggerFactory.getLogger(ConfigurationSynchroServiceImpl.class);
    public static final int VERSION_INIT = -1;
    public static final String META_FILE_EXT = ".meta";
    public static final String FILE_EXT = ".prefs";
    public static final String PROP_VERSION = "ez.version";
    public static final String PROP_SEPARATOR = "\n";
    public static final String PROP_VERSION_CONFIG_ID = "ez.config_id";
    public static final String PROP_VERSION_IGNORE = "ez.ignore_version";
    public static final String PROP_CONFIG_ID_IGNORE = "ez.ignore_config_id";
    public static final String PROP_VERSION_APPLY = "ez.apply_version";
    public static final String PROP_CONFIG_ID_APPLY = "ez.apply_config_id";
    final HashMap<String, ConfigurationInfo> configs = new HashMap();
    final EventDispatcher ed;
    final String defaultLocation;
    final String configId;
    boolean run = false;

    public ConfigurationSynchroServiceImpl(String configId, String defaultLocation, EventDispatcher ed) {
        if (configId == null) {
            throw new IllegalArgumentException("configId");
        }
        if (defaultLocation == null) {
            throw new IllegalArgumentException("defaultLocation");
        }
        this.ed = ed != null ? ed : new DefaultEventDispatcher();
        this.configId = configId;
        this.defaultLocation = defaultLocation;
    }

    public void start() {
        if (this.run) {
            throw new IllegalStateException("Already running.");
        }
        try {
            this.ed.start();
        }
        finally {
            this.run = true;
        }
    }

    public void stop() {
        if (!this.run) {
            throw new IllegalStateException("Not runing.");
        }
        try {
            this.ed.stop();
            this.configs.clear();
        }
        finally {
            this.run = false;
        }
    }

    public synchronized void registerListener(String idQualifier, ConfigurationListener listener) {
        this.ed.registerListener(idQualifier, listener);
    }

    public synchronized void registerListener(ConfigurationListener listener) {
        this.ed.registerListener(listener);
    }

    public synchronized void registerConfiguration(ConfigurationDescription description) {
        this.registerConfiguration(description, null);
    }

    public synchronized void registerConfiguration(ConfigurationDescription description, ConfigurationListener listener) {
        if (!this.run) {
            throw new IllegalStateException("Not runing.");
        }
        if (this.configs.containsKey(description.getUniqueId())) {
            throw new IllegalArgumentException("Already registered: " + description.getUniqueId());
        }
        if (listener != null) {
            this.ed.registerListener(description.getUniqueId(), listener);
        }
        if (description.getMirrorLocation() == null) {
            description = description.copy(this.defaultLocation);
            L.debug(String.format("Configuration %s: location not set, fallback to default %s", description.getUniqueId(), this.defaultLocation));
        }
        ConfigurationInfo ci = new ConfigurationInfo(description, this);
        this.configs.put(description.getUniqueId(), ci);
        ci.handler.ensureStorageDir(this.configId);
        ci.handler.ensureCurrentFiles(this.configId);
        this.scanConfiguration(ci);
    }

    public synchronized void unregisterConfiguration(String uniqueId) {
        if (!this.run) {
            throw new IllegalStateException("Not running.");
        }
        this.ed.unregisterListener(uniqueId);
        this.configs.remove(uniqueId);
    }

    public synchronized ConfigurationDescription getDescription(String uniqueId) {
        ConfigurationInfo ci = this.configs.get(uniqueId);
        if (ci != null) {
            return ci.d;
        }
        return null;
    }

    public String getFilePath(String uniqueId, long version) {
        if (!this.run) {
            throw new IllegalStateException("Not running.");
        }
        ConfigurationInfo ci = this.configs.get(uniqueId);
        if (ci == null) {
            throw new IllegalArgumentException("Not registered: " + uniqueId);
        }
        return ci.getFile(this.configId, version).getAbsolutePath();
    }

    public void resolveSync(String uniqueId, SyncResolution r, String configId, long prevVersion, String nconfigId, long nextVersion) {
        if (!this.run) {
            throw new IllegalStateException("Not running.");
        }
        if (!this.configId.equals(nconfigId)) {
            L.error(String.format("Configuration id changed, ignored until restart (old id: %s, new id: %s.", this.configId, nconfigId));
            return;
        }
        if (configId.equals(nconfigId) && nextVersion <= prevVersion) {
            throw new IllegalArgumentException("nextVersion <= currentVersion");
        }
        ConfigurationInfo ci = this.configs.get(uniqueId);
        if (ci == null) {
            throw new IllegalArgumentException("Not registered: " + uniqueId);
        }
        ci.handler.ensureCurrentFiles(this.configId);
        File mf = ci.getMetaFile();
        Properties mp = ConfigurationSynchroServiceImpl.loadProperties(mf);
        long currentVersion = ConfigurationSynchroServiceImpl.getVersion(mf, mp);
        String currentConfigId = ConfigurationSynchroServiceImpl.getConfigId(mf, mp);
        if (!currentConfigId.equals(configId) || currentVersion > prevVersion) {
            throw new ConfigurationVersionChanged(uniqueId, currentConfigId, currentVersion, configId, prevVersion);
        }
        switch (r) {
            case Apply: {
                mp.setProperty(PROP_VERSION_APPLY, String.valueOf(nextVersion));
                mp.setProperty(PROP_CONFIG_ID_APPLY, nconfigId);
                ConfigurationSynchroServiceImpl.save(mf, mp);
                L.info(String.format("Configuration %s: version [%s,%d] marked for apply now", ci.d.getUniqueId(), nconfigId, nextVersion));
                this.applyConfiguration(ci, configId, currentVersion, nconfigId, nextVersion);
                break;
            }
            case Ignore: {
                mp.setProperty(PROP_VERSION_IGNORE, String.valueOf(nextVersion));
                mp.setProperty(PROP_CONFIG_ID_IGNORE, nconfigId);
                ConfigurationSynchroServiceImpl.save(mf, mp);
                L.info(String.format("Configuration %s: version [%s.%d] marked for ignore", ci.d.getUniqueId(), nconfigId, nextVersion));
                break;
            }
            case Postpone: {
                mp.setProperty(PROP_VERSION_APPLY, String.valueOf(nextVersion));
                mp.setProperty(PROP_CONFIG_ID_APPLY, nconfigId);
                ConfigurationSynchroServiceImpl.save(mf, mp);
                L.info(String.format("Configuration %s: version [%s,%d] marked for apply at restart", ci.d.getUniqueId(), nconfigId, nextVersion));
                break;
            }
            default: {
                throw new IllegalArgumentException("Resolution not implemented: " + r);
            }
        }
    }

    public synchronized String getDefaultLocation() {
        return this.defaultLocation;
    }

    public synchronized void newVersionAvailable(String uniqueId, byte[] data, String configId, long nversion) {
        this.newVersionAvailable(uniqueId, data, null, configId, nversion);
    }

    public synchronized void newVersionAvailable(String uniqueId, byte[] data, List<byte[]> attachments, String configId, long nversion) {
        if (!this.run) {
            throw new IllegalStateException("Not running.");
        }
        if (!this.configId.equals(configId)) {
            L.error(String.format("Configuration id changed, ignored until restart (old id: %s, new id: %s.", this.configId, configId));
            return;
        }
        ConfigurationInfo ci = this.configs.get(uniqueId);
        if (ci == null) {
            throw new IllegalArgumentException("Not registered: " + uniqueId);
        }
        ci.handler.ensureCurrentFiles(this.configId);
        File mf = ci.getMetaFile();
        long version = -1L;
        Properties mp = ConfigurationSynchroServiceImpl.loadProperties(mf);
        version = ConfigurationSynchroServiceImpl.getVersion(mf, mp);
        String currentConfigId = ConfigurationSynchroServiceImpl.getConfigId(mf, mp);
        boolean changed = false;
        if (!currentConfigId.equals(configId)) {
            changed = true;
            L.info(String.format("%s configuration id changed: %s => %s.", uniqueId, currentConfigId, configId));
        } else if (nversion > version) {
            changed = true;
            L.info(String.format("%s version changed: %s => %s.", uniqueId, version, nversion));
        } else {
            L.debug(String.format("Configuration %s: new version %d less or equal to current %d.", uniqueId, nversion, version));
        }
        if (changed) {
            File nfm = ci.getMetaFile(this.configId, nversion);
            if (!nfm.exists()) {
                Object[] arr = this.findNewVersion(ci.getStorageDir(this.configId), mf.getName(), nversion);
                if (arr != null) {
                    Long newerversion = (Long)arr[1];
                    L.info(String.format("Configuration %s: newer version on the way to be saved [%s,%d]", ci.d.getUniqueId(), this.configId, newerversion));
                } else if (ci.handler.newVersionAvailable(data, attachments, this.configId, nversion)) {
                    ConfigurationSynchroServiceImpl.touchMeta(nfm, configId, nversion);
                    this.scanConfiguration(ci);
                }
            } else {
                L.info(String.format("Configuration %s: version %d already on disk.", uniqueId, nversion));
            }
        }
    }

    private void scanConfiguration(ConfigurationInfo ci) {
        File f = ci.getFile();
        File mf = ci.getMetaFile();
        long version = -1L;
        File nf = null;
        long nversion = -1L;
        Properties mp = ConfigurationSynchroServiceImpl.loadProperties(mf);
        String currentConfigId = ConfigurationSynchroServiceImpl.getConfigId(mf, mp);
        version = ConfigurationSynchroServiceImpl.getVersion(mf, mp);
        Object[] arr = currentConfigId.equals(this.configId) ? this.findNewVersion(ci.getStorageDir(this.configId), f.getName(), version) : this.findNewVersion(ci.getStorageDir(this.configId), f.getName(), -1L);
        if (arr != null) {
            nf = (File)arr[0];
            nversion = (Long)arr[1];
            L.info(String.format("Configuration %s: new version update available [%s,%d]", ci.d.getUniqueId(), this.configId, nversion));
        }
        if (nf != null) {
            Long ignoredVersion = ConfigurationSynchroServiceImpl.getLong(mf, mp, PROP_VERSION_IGNORE);
            String ignoredConfigId = mp.getProperty(PROP_CONFIG_ID_IGNORE);
            if (ignoredVersion != null && ignoredConfigId != null && ignoredConfigId.equals(this.configId) && ignoredVersion == nversion) {
                String msg = String.format("Configuration %s: version [%s,%d] ignored.", ci.d.getUniqueId(), ignoredConfigId, nversion);
                LogUtil.log(1, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.info.config.version", new String[]{ci.d.getUniqueId(), ignoredConfigId, String.valueOf(nversion)}));
                L.info(msg);
            } else {
                Long applyVersion = ConfigurationSynchroServiceImpl.getLong(mf, mp, PROP_VERSION_APPLY);
                String applyConfigId = mp.getProperty(PROP_CONFIG_ID_APPLY);
                if (applyConfigId != null && applyVersion != null && applyConfigId.equals(this.configId) && applyVersion == nversion) {
                    this.applyConfiguration(ci, this.configId, version, this.configId, nversion);
                } else {
                    ConfigurationEvent e = ci.handler.newVersionSaved(currentConfigId, version, this.configId, nversion);
                    if (e != null) {
                        this.ed.addNotification(e);
                    }
                }
            }
        }
        L.info("Deleting old versions... not yet implemented.");
    }

    private void applyConfiguration(ConfigurationInfo ci, String configId, long version, String nconfigId, long nversion) {
        String msg;
        File mf = ci.getMetaFile();
        ConfigurationEvent e = null;
        Properties mp = ConfigurationSynchroServiceImpl.loadProperties(mf);
        if (version >= 0L) {
            msg = String.format("Configuration %s: applying version transition: [%s,%d]=>[%s,%d].", ci.d.getUniqueId(), configId, version, nconfigId, nversion);
            LogUtil.log(1, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.info.applying.version.transition", new String[]{ci.d.getUniqueId(), configId, String.valueOf(version), nconfigId, String.valueOf(nversion)}));
        } else {
            msg = String.format("Configuration %s: applying version [%s,%d].", ci.d.getUniqueId(), nconfigId, nversion);
            LogUtil.log(1, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.info.applying.version", new String[]{ci.d.getUniqueId(), nconfigId, String.valueOf(nversion)}));
        }
        L.info(msg);
        e = ci.handler.applyNewVersion(this.configId, version, this.configId, nversion);
        if (e == null) {
            LogUtil.log(1, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.info.version.transition", new String[]{ci.d.getUniqueId(), configId, String.valueOf(version), nconfigId, String.valueOf(nversion)}));
        } else {
            mp.setProperty(PROP_VERSION, String.valueOf(nversion));
            mp.setProperty(PROP_VERSION_CONFIG_ID, nconfigId);
            if (!ConfigurationSynchroServiceImpl.save(mf, mp)) {
                LogUtil.log(1, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.info.version.not.saved", new String[]{ci.d.getUniqueId(), nconfigId, String.valueOf(nversion)}));
            } else {
                if (version >= 0L) {
                    msg = String.format("Configuration %s: version transition: [%s,%d]=>[%s,%d] completed.", ci.d.getUniqueId(), configId, version, nconfigId, nversion);
                    LogUtil.log(1, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.info.version.transition.completed", new String[]{ci.d.getUniqueId(), configId, String.valueOf(version), nconfigId, String.valueOf(nversion)}));
                } else {
                    msg = String.format("Configuration %s: version [%s,%d] applied.", ci.d.getUniqueId(), nconfigId, nversion);
                    LogUtil.log(1, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.info.version.applied", new String[]{ci.d.getUniqueId(), nconfigId, String.valueOf(nversion)}));
                }
                L.info(msg);
                this.ed.addNotification(e);
            }
        }
    }

    Object[] findNewVersion(File dir, final String fname, long version) {
        final AtomicLong nversion = new AtomicLong(version);
        final AtomicReference nname = new AtomicReference();
        dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int i = name.indexOf(fname);
                if (i == 0 && name.length() > fname.length() + 1) {
                    String suffix = name.substring(fname.length() + 1);
                    Long cversion = null;
                    try {
                        cversion = Long.parseLong(suffix);
                    }
                    catch (Exception exception) {}
                    if (cversion != null && cversion > nversion.get()) {
                        nversion.set(cversion);
                        nname.set(name);
                    }
                }
                return false;
            }
        });
        if (nversion.get() > version) {
            return new Object[]{new File(dir.getAbsolutePath(), (String)nname.get()), nversion.get()};
        }
        return null;
    }

    static Properties loadProperties(File f) {
        Properties p = new Properties();
        try (InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(f), "UTF8");){
            p.load(fr);
        }
        catch (Exception exception) {
            p = null;
            L.error("Can't read " + f);
        }
        return p;
    }

    static String loadJson(File f) {
        String json = null;
        boolean success = true;
        try {
            CharBuffer cb;
            try (InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(f), "UTF8");){
                cb = CharBuffer.allocate((int)f.length());
                fr.read(cb);
            }
            cb.position(0);
            json = cb.toString();
        }
        catch (Exception exception) {
            success = false;
            L.error("Can't read file: " + f);
        }
        if (success && !JsonValidator.validate(json)) {
            success = false;
            L.error("Invalid JSON: " + json);
        }
        if (!success) {
            LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.read.json", new String[]{"" + f}));
        }
        return success ? json : null;
    }

    static boolean save(File f, Properties p) {
        VersionableFile vf = new VersionableFile(f.getAbsolutePath());
        boolean success = true;
        try (OutputStreamWriter w = new OutputStreamWriter(vf.createOutputStream(), "UTF8");){
            p.store(w, null);
        }
        catch (Exception ex) {
            success = false;
            L.error("Can't write file: " + f, (Throwable)ex);
            LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.write.file", new String[]{"" + f}));
        }
        return success;
    }

    static boolean save(File f, String s) {
        VersionableFile vf = new VersionableFile(f.getAbsolutePath());
        boolean success = true;
        try (OutputStreamWriter w = new OutputStreamWriter(vf.createOutputStream(), "UTF8");){
            w.write(s);
        }
        catch (Exception ex) {
            success = false;
            L.error("Can't write file: " + f, (Throwable)ex);
            LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.write.file", new String[]{"" + f}));
        }
        return success;
    }

    static boolean saveZip(File directory, byte[] data) {
        boolean success;
        block31: {
            success = true;
            ZipInputStream zs = new ZipInputStream(new ByteArrayInputStream(data));
            try {
                try {
                    ZipEntry ze = null;
                    try {
                        ze = zs.getNextEntry();
                    }
                    catch (IOException e) {
                        success = false;
                        L.error("Can't read zip data.", (Throwable)e);
                    }
                    while (success && ze != null) {
                        if (ze.isDirectory()) {
                            File d = new File(directory, ze.getName());
                            try {
                                d = d.getCanonicalFile();
                            }
                            catch (IOException e) {
                                L.error("Extract zip: can't get canonical path: " + d, (Throwable)e);
                                success = false;
                                break;
                            }
                            if (!d.exists() && !d.mkdirs()) {
                                L.error("Extract zip: can't create " + d);
                                success = false;
                                break;
                            }
                        } else {
                            File ef = new File(directory, ze.getName());
                            File pef = ef.getParentFile();
                            if (!pef.exists() && !pef.mkdirs()) {
                                L.error("Extract zip: can't create " + ef.getParentFile());
                                success = false;
                                break;
                            }
                            try {
                                try (FilterOutputStream bos = null;){
                                    byte[] bytes = new byte[4096];
                                    int read = 0;
                                    bos = new BufferedOutputStream(new FileOutputStream(ef));
                                    while ((read = zs.read(bytes)) != -1) {
                                        ((BufferedOutputStream)bos).write(bytes, 0, read);
                                    }
                                }
                                bos.close();
                            }
                            catch (IOException e) {
                                L.error("Extract zip: can't write " + ef, (Throwable)e);
                                success = false;
                                break;
                            }
                        }
                        try {
                            ze = zs.getNextEntry();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Can't read zip.", e);
                        }
                    }
                }
                catch (Exception ex) {
                    L.error("Unexpected error.", (Throwable)ex);
                    success = false;
                    try {
                        zs.close();
                    }
                    catch (IOException ex2) {
                        L.error("Unexpected error.", (Throwable)ex2);
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                try {
                    zs.close();
                }
                catch (IOException ex) {
                    L.error("Unexpected error.", (Throwable)ex);
                }
                throw throwable;
            }
            try {
                zs.close();
            }
            catch (IOException ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
        }
        if (!success) {
            LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.zip.data"));
        }
        return success;
    }

    static long getVersion(File f, Properties p) {
        Long v = ConfigurationSynchroServiceImpl.getLong(f, p, PROP_VERSION);
        if (v == null) {
            L.error(String.format("File %s: version not found, reseting to %d", f.getAbsolutePath(), -1));
            return -1L;
        }
        return v;
    }

    static String getConfigId(File f, Properties p) {
        String configId = p.getProperty(PROP_VERSION_CONFIG_ID);
        if (configId == null) {
            throw new RuntimeException(String.format("%s: can't find property %s", f.getAbsolutePath(), PROP_VERSION_CONFIG_ID));
        }
        return configId;
    }

    static Long getLong(File f, Properties p, String key) {
        Long v = null;
        String pv = p.getProperty(key);
        if (pv != null) {
            try {
                v = Long.parseLong(pv);
            }
            catch (NumberFormatException numberFormatException) {
                L.error(String.format("Malformed long property %s=%s in file %s", key, pv, f.getAbsolutePath()));
            }
        }
        return v;
    }

    static boolean touchMeta(File f, String configId, long version) {
        boolean success = true;
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8");){
            fw.append(String.format("%s=%d%s%s=%s", PROP_VERSION, version, PROP_SEPARATOR, PROP_VERSION_CONFIG_ID, configId));
        }
        catch (IOException iOException) {
            success = false;
            L.error("Can't write to " + f);
            LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.write.to", new String[]{"" + f}));
        }
        return success;
    }

    public void notifyEvent(ConfigurationEvent ev) {
        this.ed.addNotification(ev);
    }

    public long getCurrentVersion(ConfigurationDescription confDesc) {
        ConfigurationInfo ci = this.configs.get(confDesc.getUniqueId());
        if (ci != null) {
            Properties confMeta = new Properties();
            try {
                File localFile = ci.getMetaFile();
                if (localFile != null) {
                    FileInputStream inStream = new FileInputStream(localFile);
                    confMeta.load(inStream);
                    String versStr = (String)confMeta.get(PROP_VERSION);
                    return Long.valueOf(versStr);
                }
            }
            catch (Exception ex) {
                L.error("cannot load annots meta file", (Throwable)ex);
            }
        } else {
            L.warn("cannot find configurationInfo for {}", (Object)confDesc);
        }
        return 10L;
    }

    static abstract class ConfigurationHandler {
        ConfigurationInfo ci;
        ConfigurationSynchroServiceImpl service;

        ConfigurationHandler(ConfigurationInfo ci, ConfigurationSynchroServiceImpl service) {
            this.ci = ci;
            this.service = service;
        }

        public abstract boolean newVersionAvailable(byte[] var1, List<byte[]> var2, String var3, long var4);

        public abstract ConfigurationEvent newVersionSaved(String var1, long var2, String var4, long var5);

        public abstract ConfigurationEvent applyNewVersion(String var1, long var2, String var4, long var5);

        protected void recoverContentFile(File f) {
            VersionableFile vf;
            if (!f.exists() && (vf = new VersionableFile(f.getAbsolutePath())).hasBackup()) {
                L.info(String.format("Configuration %s: a failed update detected, recovering file %s.", this.ci.d.getUniqueId(), f.getAbsoluteFile()));
                vf.recoverBackup();
                L.info(String.format("Configuration %s: file recovered.", this.ci.d.getUniqueId()));
            }
        }

        public void ensureStorageDir(String configId) {
            File d = this.ci.getStorageDir(configId);
            if (!d.exists()) {
                if (!d.mkdirs()) {
                    throw new RuntimeException("Can't create directory: " + d);
                }
            } else if (!d.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + d);
            }
        }

        public void ensureCurrentFiles(String configId) {
            File f = this.ci.getFile();
            File mf = this.ci.getMetaFile();
            File p = f.getParentFile();
            if (p.exists()) {
                if (!p.isDirectory()) {
                    throw new IllegalArgumentException("Not a directory: " + p);
                }
            } else if (!p.mkdirs()) {
                throw new RuntimeException("Can't create directory: " + p);
            }
            this.recoverContentFile(f);
            if (!mf.exists()) {
                VersionableFile vf = new VersionableFile(mf.getAbsolutePath());
                if (vf.hasBackup()) {
                    L.info(String.format("Configuration %s: a failed update detected, recovering file %s.", this.ci.d.getUniqueId(), mf.getAbsolutePath()));
                    vf.recoverBackup();
                    L.info(String.format("Configuration %s: file recovered.", this.ci.d.getUniqueId()));
                } else {
                    ConfigurationSynchroServiceImpl.touchMeta(mf, configId, -1L);
                }
            }
        }
    }

    static class ConfigurationInfo {
        final ConfigurationDescription d;
        final ConfigurationHandler handler;

        ConfigurationInfo(ConfigurationDescription d, ConfigurationSynchroServiceImpl service) {
            ConfigurationFormat f = d.getFormat();
            this.d = d;
            if (f == ConfigurationFormat.Properties || f == ConfigurationFormat.EnhancedProperties) {
                this.handler = new PropertiesHandler(this, service);
            } else if (f == ConfigurationFormat.Json) {
                this.handler = new JsonHandler(this, service);
            } else if (f == ConfigurationFormat.Directory) {
                this.handler = new ZipDirectoryHandler(this, service);
            } else {
                throw new RuntimeException("Format not supported: " + f);
            }
        }

        public File getMetaFile() {
            return new File(this.d.getMirrorLocation(), String.valueOf(this.d.getUniqueId()) + ConfigurationSynchroServiceImpl.META_FILE_EXT);
        }

        public File getMetaFile(String configId, long version) {
            if (version <= -1L) {
                return new File(new File(this.d.getMirrorLocation(), configId), String.valueOf(this.d.getUniqueId()) + ConfigurationSynchroServiceImpl.META_FILE_EXT);
            }
            return new File(new File(this.d.getMirrorLocation(), configId), String.valueOf(this.d.getUniqueId()) + ConfigurationSynchroServiceImpl.META_FILE_EXT + "." + version);
        }

        public File getFile() {
            return new File(this.d.getMirrorLocation(), String.valueOf(this.d.getUniqueId()) + ConfigurationSynchroServiceImpl.FILE_EXT);
        }

        public File getFile(String configId, long version) {
            if (version <= -1L) {
                return new File(new File(this.d.getMirrorLocation(), configId), String.valueOf(this.d.getUniqueId()) + ConfigurationSynchroServiceImpl.FILE_EXT);
            }
            return new File(new File(this.d.getMirrorLocation(), configId), String.valueOf(this.d.getUniqueId()) + ConfigurationSynchroServiceImpl.FILE_EXT + "." + version);
        }

        public File getStorageDir(String configId) {
            return new File(this.d.getMirrorLocation(), configId);
        }
    }

    static class JsonHandler
    extends ConfigurationHandler {
        JsonHandler(ConfigurationInfo ci, ConfigurationSynchroServiceImpl service) {
            super(ci, service);
        }

        @Override
        public boolean newVersionAvailable(byte[] data, List<byte[]> attachments, String nconfigId, long nversion) {
            File nf = this.ci.getFile(nconfigId, nversion);
            boolean success = true;
            String sdata = null;
            try {
                sdata = new String(data == null ? Constants.JSON_EMPTY_OBJECT_BYTES : data, "UTF8");
            }
            catch (Exception exception) {
                success = false;
                L.error(String.format("Configuration %s:%s: invalid encoding for version %d", nconfigId, this.ci.d.getUniqueId(), nversion));
            }
            if (success && !(success = JsonValidator.validate((String)sdata))) {
                L.error(String.format("Configuration %s:%s: invalid JSON for version %d", nconfigId, this.ci.d.getUniqueId(), nversion));
            }
            if (success && !(success = ConfigurationSynchroServiceImpl.save(nf, sdata))) {
                L.error(String.format("Configuration %s:%s: can't save version %d", nconfigId, this.ci.d.getUniqueId(), nversion));
            }
            if (!success) {
                LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.save.version", new String[]{nconfigId, this.ci.d.getUniqueId(), String.valueOf(nversion)}));
            }
            return success;
        }

        @Override
        public ConfigurationEvent newVersionSaved(String configId, long version, String nconfigId, long nversion) {
            File nf = this.ci.getFile(nconfigId, nversion);
            File f = this.ci.getFile();
            ConfigurationEvent e = null;
            String data = ConfigurationSynchroServiceImpl.loadJson(f);
            String ndata = ConfigurationSynchroServiceImpl.loadJson(nf);
            if (ndata != null) {
                e = new ConfigurationEvent((ConfigurationSynchroService)this.service, EventType.SyncAvailable, this.ci.d, configId, (Configuration)new JsonConfiguration(this.ci.d, data, version), nconfigId, (Configuration)new JsonConfiguration(this.ci.d, ndata, nversion));
            }
            return e;
        }

        @Override
        public ConfigurationEvent applyNewVersion(String configId, long version, String nconfigId, long nversion) {
            File nf = this.ci.getFile(nconfigId, nversion);
            File f = this.ci.getFile();
            ConfigurationEvent e = null;
            String nd = ConfigurationSynchroServiceImpl.loadJson(nf);
            if (nd != null && ConfigurationSynchroServiceImpl.save(f, nd)) {
                e = new ConfigurationEvent((ConfigurationSynchroService)this.service, EventType.SyncApplied, this.ci.d, null, null, null, null);
            }
            return e;
        }
    }

    static class PropertiesHandler
    extends ConfigurationHandler {
        public PropertiesHandler(ConfigurationInfo ci, ConfigurationSynchroServiceImpl service) {
            super(ci, service);
        }

        @Override
        public boolean newVersionAvailable(byte[] data, List<byte[]> attachments, String nconfigId, long nversion) {
            Properties p = new Properties();
            boolean success = true;
            L.debug(String.format("Configuration %s:%s will be converted to properties", nconfigId, this.ci.d.getUniqueId()));
            File nf = this.ci.getFile(nconfigId, nversion);
            JsonReader jr = null;
            try {
                jr = Json.createReader((Reader)new StringReader(new String(data == null ? Constants.JSON_EMPTY_OBJECT_BYTES : data, "UTF8")));
            }
            catch (Exception ex) {
                L.error("Can't read JSON.", (Throwable)ex);
                success = false;
            }
            if (success) {
                try {
                    PropertiesConverter.writeToProperties((JsonStructure)jr.read(), (Properties)p);
                }
                catch (Exception ex) {
                    L.error("Can't convert JSON to properties.", (Throwable)ex);
                    success = false;
                }
            }
            if (success && !(success = ConfigurationSynchroServiceImpl.save(nf, p))) {
                L.error("Can't write properties: " + nf);
            }
            if (!success) {
                LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.save.version", new String[]{nconfigId, this.ci.d.getUniqueId(), String.valueOf(nversion)}));
            }
            return success;
        }

        @Override
        public ConfigurationEvent newVersionSaved(String configId, long version, String nconfigId, long nversion) {
            File f = this.ci.getFile();
            File nf = this.ci.getFile(nconfigId, nversion);
            ConfigurationEvent e = null;
            Properties p = ConfigurationSynchroServiceImpl.loadProperties(f);
            Properties np = ConfigurationSynchroServiceImpl.loadProperties(nf);
            if (np != null) {
                PropertiesInterceptor intercept = this.ci.d.getConfigurationInterceptor();
                if (intercept != null) {
                    intercept.fillProperties(np);
                }
                if (p == null) {
                    p = new Properties();
                } else if (intercept != null) {
                    intercept.fillProperties(p);
                }
                e = new ConfigurationEvent((ConfigurationSynchroService)this.service, EventType.SyncAvailable, this.ci.d, configId, (Configuration)new VersionablePropertiesReadonly(this.ci.d, p, version), nconfigId, (Configuration)new VersionablePropertiesReadonly(this.ci.d, np, nversion));
            }
            return e;
        }

        @Override
        public ConfigurationEvent applyNewVersion(String configId, long version, String nconfigId, long nversion) {
            File nfp = this.ci.getFile(nconfigId, nversion);
            File f = this.ci.getFile();
            ConfigurationEvent e = null;
            Properties np = ConfigurationSynchroServiceImpl.loadProperties(nfp);
            if (np != null) {
                Properties op;
                PropertiesInterceptor intercept = this.ci.d.getConfigurationInterceptor();
                if (intercept != null) {
                    intercept.fillProperties(np);
                }
                if (version == -1L) {
                    op = new Properties();
                } else {
                    Properties p = ConfigurationSynchroServiceImpl.loadProperties(f);
                    if (p != null) {
                        op = (Properties)p.clone();
                        if (intercept != null) {
                            intercept.fillProperties(op);
                        }
                    } else {
                        op = new Properties();
                    }
                }
                if (ConfigurationSynchroServiceImpl.save(f, np)) {
                    e = new ConfigurationEvent((ConfigurationSynchroService)this.service, EventType.SyncApplied, this.ci.d, configId, (Configuration)new VersionablePropertiesReadonly(this.ci.d, np, nversion), nconfigId, (Configuration)new VersionablePropertiesReadonly(this.ci.d, op, version));
                }
            }
            return e;
        }
    }

    static class ZipDirectoryHandler
    extends ConfigurationHandler {
        ZipDirectoryHandler(ConfigurationInfo ci, ConfigurationSynchroServiceImpl service) {
            super(ci, service);
        }

        @Override
        public boolean newVersionAvailable(byte[] data, List<byte[]> attachments, String nconfigId, long nversion) {
            File nd = this.ci.getFile(nconfigId, nversion);
            boolean success = true;
            if (nd.exists() && !nd.delete()) {
                success = false;
                L.error("Can't delete directory: " + nd);
            }
            if (success && !nd.mkdirs()) {
                success = false;
                L.error("Can't create directory: " + nd);
            }
            File nf = new File(nd, String.valueOf(this.ci.d.getUniqueId()) + ".json");
            try {
                success = ConfigurationSynchroServiceImpl.save(nf, new String(data == null ? Constants.JSON_EMPTY_OBJECT_BYTES : data, "UTF8"));
            }
            catch (IOException ex) {
                success = false;
                L.error("Can't save file.", (Throwable)ex);
            }
            if (success && attachments != null) {
                if (attachments.size() > 1) {
                    L.error("Can't handle multiple attachment, only first will be unpackaged.");
                }
                if (attachments.size() > 0) {
                    success = ConfigurationSynchroServiceImpl.saveZip(nd, attachments.iterator().next());
                }
                if (!success) {
                    L.error("Can't save file " + nd);
                }
            }
            if (!success) {
                LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.save.version", new String[]{nconfigId, this.ci.d.getUniqueId(), String.valueOf(nversion)}));
            }
            return success;
        }

        @Override
        public ConfigurationEvent newVersionSaved(String configId, long version, String nconfigId, long nversion) {
            File nf = this.ci.getFile(nconfigId, nversion);
            File f = this.ci.getFile();
            return new ConfigurationEvent((ConfigurationSynchroService)this.service, EventType.SyncAvailable, this.ci.d, configId, (Configuration)new DirectoryConfiguration(this.ci.d, f.getAbsolutePath(), version), nconfigId, (Configuration)new DirectoryConfiguration(this.ci.d, nf.getAbsolutePath(), nversion));
        }

        @Override
        public ConfigurationEvent applyNewVersion(String configId, long version, String nconfigId, long nversion) {
            File nf = this.ci.getFile(nconfigId, nversion);
            File f = this.ci.getFile();
            boolean success = true;
            ConfigurationEvent e = null;
            if (f.exists()) {
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException ex) {
                    success = false;
                    L.error("Can't delete " + f, (Throwable)ex);
                    LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.delete", new String[]{"" + f}));
                }
            }
            if (success && !nf.renameTo(f)) {
                success = false;
                String msg = String.format("Can't rename %s to %s.", nf.getAbsolutePath(), f.getName());
                L.error(msg);
                LogUtil.log(4, Messages.getString(ConfigurationSynchroServiceImpl.class, "log.error.rename", new String[]{nf.getAbsolutePath(), f.getName()}));
            }
            if (success) {
                e = new ConfigurationEvent((ConfigurationSynchroService)this.service, EventType.SyncApplied, this.ci.d, configId, null, nconfigId, (Configuration)new DirectoryConfiguration(this.ci.d, f.getAbsolutePath(), nversion));
            }
            return e;
        }

        @Override
        protected void recoverContentFile(File f) {
            boolean stillExists = false;
            if (f.exists()) {
                if (!f.isDirectory()) {
                    L.warn("Not a directory:  + " + f.getAbsolutePath());
                    if (!f.delete()) {
                        L.error("Can't delete " + f.getAbsolutePath());
                        stillExists = true;
                    } else {
                        L.debug("Directory was deleted:  + " + f.getAbsolutePath());
                    }
                }
                stillExists = true;
            }
            if (!stillExists && !f.mkdirs()) {
                L.error("Can't mkdirs " + f.getAbsolutePath());
            }
        }
    }
}

