/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.synchro;

import com.ez.eclient.configuration.synchro.DefaultPropertyPathMapper;
import com.ez.eclient.configuration.synchro.PropertyPathMapper;
import com.ez.eclient.configuration.synchro.internal.Messages;
import com.ez.eclient.configuration.synchro.service.Configuration;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.ConfigurationEvent;
import com.ez.eclient.configuration.synchro.service.ConfigurationFormat;
import com.ez.eclient.configuration.synchro.service.ConfigurationListener;
import com.ez.eclient.configuration.synchro.service.ConfigurationSynchroService;
import com.ez.eclient.configuration.synchro.service.EventType;
import com.ez.eclient.configuration.synchro.service.LogUtil;
import com.ez.eclient.configuration.synchro.service.SyncResolution;
import com.ez.eclient.configuration.synchro.service.impl.ConfigurationSynchroServiceImpl;
import com.ez.json.tools.binding.JsonParser;
import com.ez.json.tools.binding.Path;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkEventListenerAdapter;
import com.ez.keeper.client.ZkException;
import com.ez.keeper.client.ZkMonitor;
import com.ez.keeper.client.ZkNetworkException;
import com.ez.keeper.client.ZkNoSuchNodeException;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkPath;
import com.ez.keeper.client.ZkRequestEvent;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionFactory;
import com.ez.keeper.client.request.ZkGetChildrenRequest;
import com.ez.keeper.client.request.ZkGetDataRequest;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizablePropertiesService
implements ConfigurationSynchroService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static Logger L = LoggerFactory.getLogger(SynchronizablePropertiesService.class);
    private static final int READ_ENV_RESCHEDULE_DELAY = 10000;
    private static final String META_DATA_ENC = "utf8";
    private static final String META_DATA_CONFIG_ID = "defaultConfigurationId";
    final String configDefaultLocation;
    ConfigurationSynchroServiceImpl service;
    final ZkSessionFactory sessionFactory;
    final String environmentId;
    final PropertyPathMapper pathMapper;
    final HashMap<String, ConfigInfo> configs = new HashMap();
    final List<ConfigRequest> requestQueue;
    final RepositoryMonitor rm;
    ExecutorService executor;
    String configurationId;
    ZkSession session;
    State state = State.Created;

    public SynchronizablePropertiesService(String environmentId, ZkSessionFactory sessionFactory, String configDefaultLocation) {
        this.environmentId = environmentId;
        this.sessionFactory = sessionFactory;
        this.configDefaultLocation = configDefaultLocation;
        this.session = null;
        this.pathMapper = new DefaultPropertyPathMapper(environmentId);
        this.requestQueue = new LinkedList<ConfigRequest>();
        this.rm = new RepositoryMonitor(environmentId);
    }

    public synchronized void start() {
        if (this.state != State.Created) {
            throw new IllegalStateException("Actual " + (Object)((Object)this.state) + " expected " + (Object)((Object)State.Created));
        }
        this.rm.start();
        L.info("Starting properties synchronization service.");
        this.executor = Executors.newSingleThreadExecutor();
        this.state = State.WaitStart;
    }

    public synchronized void stop() {
        if (this.state != State.Started && this.state != State.WaitStart) {
            throw new IllegalStateException("Actual " + (Object)((Object)this.state) + " expected " + (Object)((Object)State.Started));
        }
        try {
            this.rm.stop();
            if (this.requestQueue.size() > 0) {
                this.requestQueue.clear();
            }
            if (this.executor.shutdownNow().size() > 0) {
                L.error("Pending tasks canceled.");
            }
            L.info("Stopping properties synchronization service.");
            for (ConfigInfo ci : this.configs.values()) {
                try {
                    this.cleanConfiguration(ci);
                }
                catch (Exception ex) {
                    L.error("Unexpected error.", (Throwable)ex);
                }
            }
            this.releaseSession();
            if (this.state != State.WaitStart) {
                this.service.stop();
            }
        }
        finally {
            this.state = State.Created;
        }
    }

    public String getFilePath(String uniqueId, long version) {
        return this.service.getFilePath(uniqueId, version);
    }

    public ConfigurationDescription getDescription(String uniqueId) {
        return this.service.getDescription(uniqueId);
    }

    public synchronized void registerListener(String idQualifier, ConfigurationListener listener) {
        this.requestQueue.add(new ConfigRequest(idQualifier, listener));
        if (this.state == State.Started) {
            this.handlePendingRequests();
        } else {
            L.debug("Registration delayed; reason state: " + (Object)((Object)this.state));
        }
    }

    public synchronized void registerListener(ConfigurationListener listener) {
        this.requestQueue.add(new ConfigRequest(null, listener));
        if (this.state == State.Started) {
            this.handlePendingRequests();
        } else {
            L.debug("Registration delayed; reason state: " + (Object)((Object)this.state));
        }
    }

    public synchronized void registerConfiguration(ConfigurationDescription d) {
        this.registerConfiguration(d, null);
    }

    public synchronized void registerConfiguration(ConfigurationDescription d, ConfigurationListener listener) {
        if (this.state != State.Started && this.state != State.WaitStart) {
            throw new IllegalStateException("Actual " + (Object)((Object)this.state) + " expected " + (Object)((Object)State.Started));
        }
        this.requestQueue.add(new ConfigRequest(d, listener));
        if (this.state == State.Started) {
            this.handlePendingRequests();
        } else {
            L.debug("Registration delayed; reason state: " + (Object)((Object)this.state));
        }
    }

    public synchronized void unregisterConfiguration(String uniqueId) {
        if (this.state != State.Started) {
            throw new IllegalStateException("Actual " + (Object)((Object)this.state) + " expected " + (Object)((Object)State.Started));
        }
        ConfigInfo ci = this.configs.get(uniqueId);
        if (ci == null) {
            L.error("Can't find configuration: " + uniqueId);
        } else {
            this.cleanConfiguration(ci);
            this.service.unregisterConfiguration(uniqueId);
        }
    }

    public synchronized void resolveSync(String uniqueId, SyncResolution r, String configId, long currentVersion, String nconfigId, long nextVersion) {
        if (this.state != State.Started) {
            throw new IllegalStateException("Actual " + (Object)((Object)this.state) + " expected " + (Object)((Object)State.Started));
        }
        this.service.resolveSync(uniqueId, r, configId, currentVersion, nconfigId, nextVersion);
    }

    private synchronized void onDataAvailable(String uniqueId, final byte[] d, final long mzxid, final int version) {
        final ConfigInfo ci = this.configs.get(uniqueId);
        if (ci == null) {
            L.error("Can't find configuration: " + uniqueId);
        } else {
            final ConfigurationSynchroServiceImpl service = this.service;
            final ZkSession session = this.session;
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        SynchronizablePropertiesService.this.processDataAvailableEvent(service, session, ci, d, mzxid, version);
                    }
                    catch (Exception e) {
                        L.error("Unexpected error.", (Throwable)e);
                    }
                }
            });
        }
    }

    private void ensureSession() {
        if (this.session == null) {
            this.session = this.sessionFactory.getSession();
        }
    }

    private void releaseSession() {
        if (this.session != null) {
            try {
                this.sessionFactory.release(this.session);
            }
            catch (Exception ex) {
                L.error("Can't release session.", (Throwable)ex);
            }
        }
    }

    private void cleanConfiguration(ConfigInfo ci) {
        try {
            this.stopMonitor(ci);
        }
        finally {
            this.service.unregisterConfiguration(ci.uniqueId);
        }
    }

    private void startMonitor(ConfigInfo ci) {
        final String uid = ci.uniqueId;
        ZkEventListenerAdapter l = new ZkEventListenerAdapter(){
            Logger L = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            boolean networkError;
            boolean error;

            public void notifyNodeDataAvailable(ZkNodeEvent e) {
                this.networkError = false;
                SynchronizablePropertiesService.this.onDataAvailable(uid, (byte[])e.getData(), e.getStat().getMzxid(), e.getStat().getVersion());
            }

            public void notifyRequestFinished(ZkRequestEvent e) {
                boolean prevNetworkEx = this.networkError;
                this.networkError = false;
                if (e.hasError()) {
                    Exception ex = e.getException();
                    if (ex instanceof ZkNetworkException) {
                        this.networkError = true;
                        if (!prevNetworkEx) {
                            this.L.info(String.format("%s: network lost.", uid));
                        }
                        this.L.trace(String.format("%s: request failed.", uid), (Throwable)e.getException());
                    } else if (this.error) {
                        this.L.trace(String.format("%s: request failed.", uid), (Throwable)e.getException());
                    } else {
                        this.L.error(String.format("%s: request failed.", uid), (Throwable)e.getException());
                    }
                    this.error = true;
                }
            }
        };
        ci.monitor = this.session.watch(ci.serverPath, (ZkEventListener)l, String.format("uniqueId: %s", uid), Integer.valueOf(0));
    }

    private void stopMonitor(ConfigInfo ci) {
        try {
            ci.monitor.stop();
        }
        catch (Exception ex) {
            L.error("Can't stop monitor.", (Throwable)ex);
        }
    }

    private void processDataAvailableEvent(ConfigurationSynchroServiceImpl service, ZkSession session, ConfigInfo ci, byte[] data, long transactionId, int version) {
        if (ci.attachmentsPath == null) {
            service.newVersionAvailable(ci.uniqueId, data, Collections.emptyList(), this.configurationId, version);
        } else {
            List children;
            L.debug(String.format("Configuration %s: transaction %d version %d reading attachments...", ci.uniqueId, transactionId, version));
            LinkedList<byte[]> attachmentsData = new LinkedList<byte[]>();
            Object[] rea = this.executeRequest(session, (ZkRequest)new ZkGetChildrenRequest(ci.attachmentsPath), transactionId);
            Object redata = rea[0];
            RequestResult re = (RequestResult)((Object)rea[1]);
            if (re == RequestResult.Success && (children = (List)redata) != null) {
                for (String child : children) {
                    String attachmentPath = ZkPath.join((String)ci.attachmentsPath, (String[])new String[]{child});
                    rea = this.executeRequest(session, (ZkRequest)new ZkGetDataRequest(attachmentPath), transactionId);
                    redata = rea[0];
                    re = (RequestResult)((Object)rea[1]);
                    if (re != RequestResult.Success) break;
                    attachmentsData.add((byte[])redata);
                }
            }
            if (re == RequestResult.Success) {
                service.newVersionAvailable(ci.uniqueId, data, attachmentsData, this.configurationId, version);
            } else if (re == RequestResult.Stale) {
                L.debug(String.format("Configuration %s: transaction %d version %d staled, ignore event and wait next update.", ci.uniqueId, transactionId, version));
            } else if (re == RequestResult.Failed) {
                L.debug(String.format("Configuration %s: transaction %d version %d failed reading attachments data.", ci.uniqueId, transactionId, version));
                this.stopMonitor(ci);
                this.startMonitor(ci);
            } else {
                throw new RuntimeException("Internal error.");
            }
        }
    }

    private Object[] executeRequest(ZkSession session, ZkRequest r, long transactionId) {
        RequestResult re = RequestResult.Success;
        Object data = null;
        try {
            ZkResult zkre = session.execute(r);
            data = zkre.getData();
            long dataTransactionId = zkre.getStat().getMzxid();
            if (dataTransactionId > transactionId) {
                re = RequestResult.Stale;
            }
        }
        catch (ZkNoSuchNodeException zkNoSuchNodeException) {
            re = RequestResult.Success;
        }
        catch (ZkException ex) {
            re = RequestResult.Failed;
            L.error("Unexpected error.", (Throwable)ex);
        }
        catch (Exception ex) {
            re = RequestResult.Failed;
            L.error("Unexpected error.", (Throwable)ex);
        }
        return new Object[]{data, re};
    }

    private synchronized void onConfigurationAvailable(String configId) {
        L.debug(String.format("Environment %s: configuration id available: %s", this.environmentId, configId));
        if (this.state == State.WaitStart) {
            this.service = new ConfigurationSynchroServiceImpl(configId, this.configDefaultLocation, null);
            this.service.start();
            this.configurationId = configId;
            this.handlePendingRequests();
            this.state = State.Started;
        } else {
            L.debug("Configuration ignored; reason state: " + (Object)((Object)this.state));
        }
    }

    private void handlePendingRequests() {
        for (ConfigRequest cr : this.requestQueue) {
            if (cr.d != null) {
                this.lazyRegisterConfiguration(cr.d, cr.listener);
                continue;
            }
            if (cr.idQualifier != null) {
                this.lazyRegisterListener(cr.idQualifier, cr.listener);
                continue;
            }
            this.lazyRegisterListener(cr.listener);
        }
        this.requestQueue.clear();
    }

    public void lazyRegisterListener(String idQualifier, ConfigurationListener listener) {
        this.service.registerListener(idQualifier, listener);
    }

    public void lazyRegisterListener(ConfigurationListener listener) {
        this.service.registerListener(listener);
    }

    public void lazyRegisterConfiguration(ConfigurationDescription d, ConfigurationListener listener) {
        String attachmentsPath = null;
        this.ensureSession();
        String serverPath = this.pathMapper.getServerPath(this.configurationId, d.getNamespace(), d.getUniqueId(), d.getFormat());
        if (d.getFormat() == ConfigurationFormat.Directory) {
            attachmentsPath = this.pathMapper.getServerAttachmentsPath(this.configurationId, d.getNamespace(), d.getUniqueId(), d.getFormat());
        }
        ConfigInfo ci = new ConfigInfo(d.getUniqueId(), serverPath, attachmentsPath, null);
        this.startMonitor(ci);
        this.service.registerConfiguration(d, listener);
        this.configs.put(d.getUniqueId(), ci);
    }

    public void dispatchSyncAvailableEvent(ConfigurationDescription confDesc, Configuration oldConfig, Configuration newConfig) {
        ConfigurationEvent ev = new ConfigurationEvent((ConfigurationSynchroService)this.service, EventType.SyncAvailable, confDesc, this.configurationId, newConfig, this.configurationId, oldConfig);
        this.service.notifyEvent(ev);
    }

    public long getCurrentVersion(ConfigurationDescription confDesc) {
        return this.service.getCurrentVersion(confDesc);
    }

    private class ConfigInfo {
        final String uniqueId;
        final String serverPath;
        final String attachmentsPath;
        final String toString;
        ZkMonitor monitor;

        ConfigInfo(String uniqueId, String serverPath, String attachmentsPath, ZkMonitor monitor) {
            this.uniqueId = uniqueId;
            this.serverPath = serverPath;
            this.attachmentsPath = attachmentsPath;
            this.monitor = monitor;
            this.toString = String.format("uniqueId: %s", uniqueId);
        }

        public String toString() {
            return this.toString;
        }
    }

    private class ConfigRequest {
        String idQualifier;
        ConfigurationListener listener;
        ConfigurationDescription d;

        ConfigRequest(String idQualifier, ConfigurationListener listener) {
            this.idQualifier = idQualifier;
            this.listener = listener;
        }

        ConfigRequest(ConfigurationDescription d, ConfigurationListener listener) {
            this.d = d;
            this.listener = listener;
        }
    }

    private class RepositoryMonitor {
        final ScheduledExecutorService exec;
        final String envId;
        boolean noDefaultConfig = false;
        volatile boolean active = false;

        RepositoryMonitor(String envId) {
            this.envId = envId;
            this.exec = Executors.newScheduledThreadPool(1);
        }

        public void start() {
            this.active = true;
            this.schedule(1);
        }

        public void stop() {
            this.active = false;
            this.exec.shutdown();
        }

        private void schedule(int delay) {
            this.exec.schedule(new Runnable(){

                @Override
                public void run() {
                    if (RepositoryMonitor.this.active) {
                        L.debug("Fetch environment metadata.");
                        try {
                            RepositoryMonitor.this.fetchEnvironemntDetails();
                        }
                        catch (Throwable ex) {
                            L.error("Can't read environment details.", ex);
                            if (!(ex instanceof Exception)) {
                                throw new RuntimeException(ex);
                            }
                            RepositoryMonitor.this.schedule(10000);
                        }
                    } else {
                        L.debug("Inactive, cancel.");
                    }
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }

        private void fetchEnvironemntDetails() {
            ZkSession s = SynchronizablePropertiesService.this.sessionFactory.getSession();
            try {
                String metaPath = SynchronizablePropertiesService.this.pathMapper.getEnvironmentMetadataPath(this.envId);
                ZkResult re = null;
                String json = null;
                re = s.execute((ZkRequest)new ZkGetDataRequest(metaPath));
                try {
                    json = new String((byte[])re.getData(), SynchronizablePropertiesService.META_DATA_ENC);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                Object jsono = JsonParser.parseJson((Reader)new StringReader(json));
                String configId = (String)Path.getObject((Object)jsono, (String)SynchronizablePropertiesService.META_DATA_CONFIG_ID);
                if (configId == null) {
                    String msg = String.format("Environment %s: configuration not set in metadata.", this.envId);
                    if (this.noDefaultConfig) {
                        L.trace(msg);
                    } else {
                        L.debug(msg);
                        LogUtil.log(2, Messages.getString(SynchronizablePropertiesService.class, "log.warning", new String[]{this.envId}));
                    }
                    this.noDefaultConfig = true;
                    throw new IllegalStateException(msg);
                }
                L.debug("Configuration id found.");
                this.noDefaultConfig = false;
                SynchronizablePropertiesService.this.onConfigurationAvailable(configId);
            }
            finally {
                try {
                    SynchronizablePropertiesService.this.sessionFactory.release(s);
                }
                catch (Exception ex) {
                    L.error("Can't release sesison.", (Throwable)ex);
                }
            }
        }
    }

    private static enum RequestResult {
        Success,
        Stale,
        Failed;

    }

    private static enum State {
        Created,
        WaitStart,
        Started;

    }
}

