/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.synchro;

import com.ez.eclient.configuration.synchro.Configurator;
import com.ez.eclient.configuration.synchro.PropertiesEclipseService;
import com.ez.eclient.configuration.synchro.SynchronizablePropertiesService;
import com.ez.eclient.configuration.synchro.internal.Messages;
import com.ez.eclient.configuration.synchro.service.ConfigurationSynchroService;
import com.ez.eclient.configuration.synchro.service.LogUtil;
import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.preferences.EnvironmentPreferences;
import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.configuration.IConfigurationService;
import com.ez.eclient.service.configuration.impl.DefaultConfigurationService;
import com.ez.eclient.service.configuration.waziproxy.IWaziProxyService;
import com.ez.eclient.service.configuration.waziproxy.impl.DefaultWaziProxyService;
import com.ez.eclient.service.database.DatabaseService;
import com.ez.eclient.service.database.impl.DefaultDatabaseService;
import com.ez.eclient.service.rsrv.cross.CrossService;
import com.ez.eclient.service.rsrv.cross.impl.DefaultCrossService;
import com.ez.eclient.service.rsrv.fileservice.FileServerService;
import com.ez.eclient.service.rsrv.fileservice.impl.DefaultFileServerService;
import com.ez.eclient.service.rsrv.mfprojects.IMainframeProjectsService;
import com.ez.eclient.service.rsrv.mfprojects.impl.DefaultMainframeProjectsService;
import com.ez.eclient.service.rsrv.resolutions.ManualResolutionsService;
import com.ez.eclient.service.rsrv.resolutions.impl.DefaultManualResolutionsService;
import com.ez.eclient.service.rsrv.search.SearchInFilesService;
import com.ez.eclient.service.rsrv.search.impl.DefaultSearchService;
import com.ez.ezsource.connection.zkbridge.db.DBEntityAdapterFactoryImpl;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionFactory;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesEclipseServiceImpl
implements PropertiesEclipseService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\ufffd Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Logger L = LoggerFactory.getLogger(this.getClass());
    ZkSessionFactory sessionFactory;
    SynchronizablePropertiesService sps;
    DatabaseService dbs;
    FileServerService fileSrv;
    DefaultSearchService searchSrv;
    ManualResolutionsService manualResolutionsSrv;
    IMainframeProjectsService mfProjsrv;
    CrossService crossSrv;
    DefaultWaziProxyService waziProxySrv;
    DefaultConfigurationService configurationSrv;
    private ServiceRegistration dbSr;
    private ServiceRegistration fileSr;
    private ServiceRegistration searchSr;
    private ServiceRegistration manResSr;
    private ServiceRegistration mfProjSr;
    private ServiceRegistration crossSr;
    private ServiceRegistration waziProxySr;
    private ServiceRegistration configurationSr;
    private BundleContext context;

    @Override
    public ConfigurationSynchroService getPropertiesService() {
        return this.sps;
    }

    protected void setZookeeperSessionFactory(ZkSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected void unsetZookeeperSessionFactory(ZkSessionFactory sf) {
        this.sessionFactory = null;
    }

    protected void activate(ComponentContext ctx) {
        Environment e = EnvironmentPreferences.getEnvironment();
        List<Configurator> cl = null;
        if (e == null) {
            this.L.error("Environment not configured.");
            LogUtil.log(4, Messages.getString(PropertiesEclipseServiceImpl.class, "log.error.environment.not.configured"));
        } else {
            Properties p = new Properties();
            this.context = ctx.getBundleContext();
            AppLogger log = new AppLogger();
            cl = this.loadExtensions();
            for (Configurator c : cl) {
                c.preConfigure(p);
            }
            String configDefaultLocation = p.getProperty("configuration.default_root_location");
            if (configDefaultLocation == null) {
                this.L.error("Property not set: {}", (Object)"configuration.default_root_location");
                LogUtil.log(4, Messages.getString(PropertiesEclipseServiceImpl.class, "log.error.property.not.set", new String[]{"configuration.default_root_location"}));
            } else {
                this.L.info("Environment configuration will be mirrored locally in directory: {}", (Object)configDefaultLocation);
                if (!this.prepareMirrorLocation(configDefaultLocation)) {
                    this.L.error("Can't prepare directory: {}", (Object)configDefaultLocation);
                    LogUtil.log(4, Messages.getString(PropertiesEclipseServiceImpl.class, "log.error.prepare.directory", new String[]{configDefaultLocation}));
                } else {
                    this.sps = new SynchronizablePropertiesService(e.getId(), this.sessionFactory, configDefaultLocation);
                }
            }
            this.prepareConfigurationService(e, log);
            this.prepareWaziProxyService(e, log);
            this.prepareDbService(e, log);
            this.prepareMfProjService(e, log);
            this.prepareFileService(e, log);
            this.prepareSearchService(e, log);
            this.prepareManualResolutionsService(e, log);
            this.prepareCrossService(e, log);
        }
        if (this.sps == null) {
            this.L.error("Synchronization service will not be started.");
            LogUtil.log(4, Messages.getString(PropertiesEclipseServiceImpl.class, "log.error.synchronization"));
        } else {
            this.sps.start();
            if (cl != null) {
                for (Configurator c : cl) {
                    try {
                        c.postConfigure((ConfigurationSynchroService)this.sps);
                    }
                    catch (Exception ex) {
                        this.L.error("Uncaught exception.", (Throwable)ex);
                    }
                }
            }
        }
    }

    protected void deactivate(ComponentContext ctx) {
        if (this.sps != null) {
            this.sps.stop();
        }
        if (this.fileSr != null) {
            this.context.ungetService(this.fileSr.getReference());
        }
        if (this.fileSrv != null) {
            this.fileSrv.stop(true);
        }
        if (this.searchSr != null) {
            this.context.ungetService(this.searchSr.getReference());
        }
        if (this.searchSrv != null) {
            this.searchSrv.stop(true);
        }
        if (this.manResSr != null) {
            this.context.ungetService(this.manResSr.getReference());
        }
        if (this.manualResolutionsSrv != null) {
            this.manualResolutionsSrv.stop(true);
        }
        if (this.mfProjSr != null) {
            this.context.ungetService(this.mfProjSr.getReference());
        }
        if (this.mfProjsrv != null) {
            this.mfProjsrv.stop(true);
        }
        if (this.dbSr != null) {
            this.context.ungetService(this.dbSr.getReference());
        }
        if (this.dbs != null) {
            ((DefaultDatabaseService)this.dbs).stop(true);
        }
        if (this.crossSr != null) {
            this.context.ungetService(this.crossSr.getReference());
        }
        if (this.crossSrv != null) {
            this.crossSrv.stop(true);
        }
    }

    private boolean prepareMirrorLocation(String location) {
        File fileLocation = new File(location);
        if (fileLocation.exists() && !fileLocation.isDirectory()) {
            this.L.info("{} is not a directory, will delete it.", (Object)fileLocation);
            if (!fileLocation.delete()) {
                this.L.error("Can't delete file: {}", (Object)fileLocation);
                return false;
            }
        }
        if (!fileLocation.exists() && !fileLocation.mkdirs()) {
            this.L.error("Can't mkdirs: {}", (Object)fileLocation);
            return false;
        }
        return true;
    }

    private List<Configurator> loadExtensions() {
        LinkedList<Configurator> cl = new LinkedList<Configurator>();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ez.eclient.configuration.synchro.configurator");
        if (configs != null) {
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                Object e = null;
                try {
                    e = ce.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    this.L.error("Can't create extension.", (Throwable)ex);
                }
                if (e != null && e instanceof Configurator) {
                    cl.add((Configurator)e);
                }
                ++n2;
            }
        }
        return cl;
    }

    private void prepareMfProjService(Environment e, AppLogger log) {
        this.L.debug("prepareMfProjService");
        ZkSession session = this.sessionFactory.getSession();
        if (session == null) {
            throw new IllegalStateException("Can't get session.");
        }
        boolean serviceStarted = false;
        try {
            this.mfProjsrv = new DefaultMainframeProjectsService(session, e.getId(), (IAppLogger)log);
            this.mfProjsrv.start();
            serviceStarted = true;
            this.mfProjSr = this.context.registerService(IMainframeProjectsService.class.getName(), (Object)this.mfProjsrv, null);
        }
        finally {
            block15: {
                if (!serviceStarted) {
                    try {
                        try {
                            this.L.error("Mainframe Projects service not started.");
                            this.sessionFactory.release(session);
                        }
                        catch (Exception ex) {
                            this.L.error("Can't release factory.", (Throwable)ex);
                            this.mfProjsrv = null;
                            session = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.mfProjsrv = null;
                        session = null;
                        throw throwable;
                    }
                    this.mfProjsrv = null;
                    session = null;
                }
            }
        }
    }

    private void prepareWaziProxyService(Environment e, AppLogger log) {
        block23: {
            String configurationId;
            this.L.debug("prepareWaziProxyService");
            if (this.configurationSrv != null || this.configurationSr != null) {
                this.L.debug("prepareWaziProxyService - getting configuration id !");
                configurationId = this.configurationSrv.getConfigurationId();
            } else {
                this.prepareConfigurationService(e, log);
                if (this.configurationSrv == null || this.configurationSr == null) {
                    this.L.debug("prepareWaziProxyService - Wazi Proxy service not started. configurationSrv: {} and configurationSr: {} ", (Object)this.configurationSrv, (Object)this.configurationSr);
                    return;
                }
                this.L.debug("prepareWaziProxyService - getting configuration id !");
                configurationId = this.configurationSrv.getConfigurationId();
            }
            ZkSession session = this.sessionFactory.getSession();
            if (session == null) {
                throw new IllegalStateException("Can't get session.");
            }
            boolean serviceStarted = false;
            try {
                try {
                    this.waziProxySrv = new DefaultWaziProxyService(session, e.getId(), (IAppLogger)log, configurationId);
                    this.waziProxySrv.start();
                    serviceStarted = true;
                    this.waziProxySr = this.context.registerService(IWaziProxyService.class.getName(), (Object)this.waziProxySrv, null);
                }
                catch (Exception ex) {
                    this.L.error("Error:", (Throwable)ex);
                    if (serviceStarted) break block23;
                    try {
                        try {
                            this.L.error("Wazi Proxy service not started.");
                            this.sessionFactory.release(session);
                        }
                        catch (Exception ex2) {
                            this.L.error("Can't release factory.", (Throwable)ex2);
                            this.waziProxySrv = null;
                            session = null;
                        }
                    }
                    finally {
                        this.waziProxySrv = null;
                        session = null;
                    }
                }
            }
            finally {
                block25: {
                    if (!serviceStarted) {
                        try {
                            try {
                                this.L.error("Wazi Proxy service not started.");
                                this.sessionFactory.release(session);
                            }
                            catch (Exception ex) {
                                this.L.error("Can't release factory.", (Throwable)ex);
                                this.waziProxySrv = null;
                                session = null;
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            this.waziProxySrv = null;
                            session = null;
                            throw throwable;
                        }
                        this.waziProxySrv = null;
                        session = null;
                    }
                }
            }
        }
    }

    private void prepareConfigurationService(Environment e, AppLogger log) {
        block21: {
            this.L.debug("prepareConfigurationService");
            if (this.configurationSrv != null || this.configurationSr != null) {
                this.L.debug("prepareConfigurationService was already called - configurationSrv: {} and configurationSr: {} ", (Object)this.configurationSrv, (Object)this.configurationSr);
                return;
            }
            ZkSession session = this.sessionFactory.getSession();
            if (session == null) {
                throw new IllegalStateException("Can't get session.");
            }
            boolean serviceStarted = false;
            try {
                try {
                    this.configurationSrv = new DefaultConfigurationService(session, e.getId(), (IAppLogger)log);
                    this.configurationSrv.start();
                    serviceStarted = true;
                    this.configurationSr = this.context.registerService(IConfigurationService.class.getName(), (Object)this.configurationSrv, null);
                }
                catch (Exception ex) {
                    this.L.error("Error:", (Throwable)ex);
                    if (serviceStarted) break block21;
                    try {
                        try {
                            this.L.error("Configuration service not started.");
                            this.sessionFactory.release(session);
                        }
                        catch (Exception ex2) {
                            this.L.error("Can't release factory.", (Throwable)ex2);
                            this.configurationSrv = null;
                            session = null;
                        }
                    }
                    finally {
                        this.configurationSrv = null;
                        session = null;
                    }
                }
            }
            finally {
                block23: {
                    if (!serviceStarted) {
                        try {
                            try {
                                this.L.error("Configuration service not started.");
                                this.sessionFactory.release(session);
                            }
                            catch (Exception ex) {
                                this.L.error("Can't release factory.", (Throwable)ex);
                                this.configurationSrv = null;
                                session = null;
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            this.configurationSrv = null;
                            session = null;
                            throw throwable;
                        }
                        this.configurationSrv = null;
                        session = null;
                    }
                }
            }
        }
    }

    private void prepareDbService(Environment e, AppLogger log) {
        this.L.debug("prepareDbService");
        ZkSession session = this.sessionFactory.getSession();
        if (session == null) {
            throw new IllegalStateException("Can't get session.");
        }
        boolean serviceStarted = false;
        try {
            this.dbs = new DefaultDatabaseService(session, e.getId(), (IAppLogger)log, (EntityAdapterFactory)new DBEntityAdapterFactoryImpl());
            this.dbs.start();
            serviceStarted = true;
            this.dbSr = this.context.registerService(DatabaseService.class.getName(), (Object)this.dbs, null);
        }
        finally {
            block15: {
                if (!serviceStarted) {
                    try {
                        try {
                            this.L.error("Database service not started.");
                            this.sessionFactory.release(session);
                        }
                        catch (Exception ex) {
                            this.L.error("Can't release factory.", (Throwable)ex);
                            this.dbs = null;
                            session = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.dbs = null;
                        session = null;
                        throw throwable;
                    }
                    this.dbs = null;
                    session = null;
                }
            }
        }
    }

    private void prepareFileService(Environment e, AppLogger log) {
        this.L.debug("prepareFileServerService");
        ZkSession session = this.sessionFactory.getSession();
        if (session == null) {
            throw new IllegalStateException("Can't get session.");
        }
        boolean serviceStarted = false;
        try {
            this.fileSrv = new DefaultFileServerService(session, e.getId(), (IAppLogger)log);
            this.fileSrv.start();
            serviceStarted = true;
            this.fileSr = this.context.registerService(FileServerService.class.getName(), (Object)this.fileSrv, null);
        }
        finally {
            block15: {
                if (!serviceStarted) {
                    try {
                        try {
                            this.L.error("FileServer service not started.");
                            this.sessionFactory.release(session);
                        }
                        catch (Exception ex) {
                            this.L.error("Can't release session.", (Throwable)ex);
                            this.fileSrv = null;
                            session = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.fileSrv = null;
                        session = null;
                        throw throwable;
                    }
                    this.fileSrv = null;
                    session = null;
                }
            }
        }
    }

    private void prepareSearchService(Environment e, AppLogger log) {
        this.L.debug("prepareSearchInFilesService");
        ZkSession session = this.sessionFactory.getSession();
        if (session == null) {
            throw new IllegalStateException("Can't get session.");
        }
        boolean serviceStarted = false;
        try {
            this.searchSrv = new DefaultSearchService(session, e.getId(), (IAppLogger)log);
            this.searchSrv.start();
            serviceStarted = true;
            this.searchSr = this.context.registerService(SearchInFilesService.class.getName(), (Object)this.searchSrv, null);
        }
        finally {
            block15: {
                if (!serviceStarted) {
                    try {
                        try {
                            this.L.error("SearchInFiles service not started.");
                            this.sessionFactory.release(session);
                        }
                        catch (Exception ex) {
                            this.L.error("Can't release session.", (Throwable)ex);
                            this.searchSrv = null;
                            session = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.searchSrv = null;
                        session = null;
                        throw throwable;
                    }
                    this.searchSrv = null;
                    session = null;
                }
            }
        }
    }

    private void prepareManualResolutionsService(Environment e, AppLogger log) {
        this.L.debug("prepareManualResolutionsService");
        boolean serviceStarted = false;
        try {
            UUID appID = UUID.randomUUID();
            UUID environmentID = UUID.fromString(e.getId());
            this.manualResolutionsSrv = new DefaultManualResolutionsService(this.sessionFactory, environmentID, appID, (IAppLogger)log);
            this.manualResolutionsSrv.start();
            serviceStarted = true;
            this.manResSr = this.context.registerService(ManualResolutionsService.class.getName(), (Object)this.manualResolutionsSrv, null);
        }
        finally {
            block14: {
                if (!serviceStarted) {
                    try {
                        try {
                            this.L.error("ManualResolutions service not started.");
                        }
                        catch (Exception ex) {
                            this.L.error("Can't release session.", (Throwable)ex);
                            this.manualResolutionsSrv = null;
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        this.manualResolutionsSrv = null;
                        throw throwable;
                    }
                    this.manualResolutionsSrv = null;
                }
            }
        }
    }

    private void prepareCrossService(Environment e, AppLogger log) {
        this.L.debug("prepareCrossService");
        ZkSession session = this.sessionFactory.getSession();
        if (session == null) {
            throw new IllegalStateException("Can't get session.");
        }
        boolean serviceStarted = false;
        try {
            UUID environmentID = UUID.fromString(e.getId());
            this.crossSrv = new DefaultCrossService(this.sessionFactory, environmentID, null, (IAppLogger)log);
            this.crossSrv.start();
            serviceStarted = true;
            this.crossSr = this.context.registerService(CrossService.class.getName(), (Object)this.crossSrv, null);
        }
        finally {
            block15: {
                if (!serviceStarted) {
                    try {
                        try {
                            this.L.error("cross service not started.");
                            this.sessionFactory.release(session);
                        }
                        catch (Exception ex) {
                            this.L.error("Can't release session.", (Throwable)ex);
                            this.crossSrv = null;
                            session = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.crossSrv = null;
                        session = null;
                        throw throwable;
                    }
                    this.crossSrv = null;
                    session = null;
                }
            }
        }
    }

    private static class AppLogger
    implements IAppLogger {
        private AppLogger() {
        }

        public void error(String msg) {
            LogUtil.log(4, msg);
        }

        public void error(String msg, Throwable t) {
            LogUtil.log(4, msg, t);
        }

        public void info(String msg) {
            LogUtil.log(1, msg);
        }
    }
}

