/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.synchro;

import com.ez.eclient.configuration.synchro.PropertyPathMapper;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.ConfigurationFormat;

public class DefaultPropertyPathMapper
implements PropertyPathMapper {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String ENV_PATH_TPL = "/ez/ad/environment/environment-%s";
    public static final String ENV_META_PATH_TPL = "/ez/ad/environment/environment-%s/metadata";
    public static final String SERVER_PATH_TPL = "/ez/ad/environment/environment-%s/configuration/configuration-%s/%s/%s";
    public static final String SERVER_ATTACHMENTS_PATH_TPL = "/ez/ad/environment/environment-%s/configuration/configuration-%s/%s/%s/attachment";
    protected final String environmentId;

    public DefaultPropertyPathMapper(String environmentId) {
        if (environmentId == null) {
            throw new IllegalArgumentException("environmentId");
        }
        this.environmentId = environmentId;
    }

    @Override
    public String getEnvironmentMetadataPath(String envUniqueId) {
        if (envUniqueId == null) {
            throw new IllegalArgumentException("envUniqueId");
        }
        return String.format(ENV_META_PATH_TPL, envUniqueId);
    }

    @Override
    public String getServerPath(String configurationId, String namespace, String uniqueId, ConfigurationFormat f) {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace");
        }
        if (uniqueId == null) {
            throw new IllegalArgumentException("uniqueId");
        }
        String serverShortPath = this.convertConfigId(uniqueId);
        return String.format(SERVER_PATH_TPL, this.environmentId, configurationId, namespace, serverShortPath);
    }

    @Override
    public String getServerAttachmentsPath(String configurationId, String namespace, String uniqueId, ConfigurationFormat f) {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace");
        }
        if (uniqueId == null) {
            throw new IllegalArgumentException("uniqueId");
        }
        String serverShortPath = this.convertConfigId(uniqueId);
        return String.format(SERVER_ATTACHMENTS_PATH_TPL, this.environmentId, configurationId, namespace, serverShortPath);
    }

    String convertConfigId(String uniqueId) {
        if (!ConfigurationDescription.validateUniqueId((String)uniqueId)) {
            throw new IllegalArgumentException("Not a valid id: " + uniqueId);
        }
        StringBuilder b = new StringBuilder();
        String[] segs = uniqueId.split("[.]");
        int i = 0;
        while (i < segs.length) {
            if (i > 0) {
                b.append("/");
            }
            b.append(segs[i]);
            ++i;
        }
        return b.toString();
    }
}

