/*
 * Decompiled with CFR 0.152.
 */
package naga2.packetwriter;

import java.nio.ByteBuffer;
import naga2.NIOUtils;
import naga2.PacketWriter;

public class RegularPacketWriter
implements PacketWriter {
    private final boolean m_bigEndian;
    private final ByteBuffer m_header;

    public RegularPacketWriter(int headerSize, boolean bigEndian) {
        if (headerSize < 1 || headerSize > 4) {
            throw new IllegalArgumentException("Header must be between 1 and 4 bytes long.");
        }
        this.m_bigEndian = bigEndian;
        this.m_header = ByteBuffer.allocate(headerSize);
    }

    @Override
    public ByteBuffer[] write(ByteBuffer[] byteBuffers) {
        this.m_header.clear();
        NIOUtils.setPacketSizeInByteBuffer(this.m_header, this.m_header.capacity(), (int)NIOUtils.remaining(byteBuffers), this.m_bigEndian);
        this.m_header.flip();
        return NIOUtils.concat(this.m_header, byteBuffers);
    }
}

