/*
 * Decompiled with CFR 0.152.
 */
package naga2.packetwriter;

import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import naga2.PacketWriter;

public class CipherPacketWriter
implements PacketWriter {
    private final Cipher m_cipher;
    private PacketWriter m_packetWriter;

    public CipherPacketWriter(Cipher cipher, PacketWriter packetWriter) {
        this.m_cipher = cipher;
        this.m_packetWriter = packetWriter;
    }

    public PacketWriter getPacketWriter() {
        return this.m_packetWriter;
    }

    public void setPacketWriter(PacketWriter packetWriter) {
        this.m_packetWriter = packetWriter;
    }

    @Override
    public ByteBuffer[] write(ByteBuffer[] byteBuffer) {
        byteBuffer = this.m_packetWriter.write(byteBuffer);
        ByteBuffer[] resultBuffer = new ByteBuffer[byteBuffer.length];
        try {
            for (int i = 0; i < byteBuffer.length; ++i) {
                resultBuffer[i] = ByteBuffer.allocate(this.m_cipher.getOutputSize(byteBuffer[i].remaining()));
                if (i == byteBuffer.length - 1) {
                    this.m_cipher.doFinal(byteBuffer[i], resultBuffer[i]);
                } else {
                    this.m_cipher.update(byteBuffer[i], resultBuffer[i]);
                }
                assert (byteBuffer[i].remaining() == 0);
                resultBuffer[i].flip();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return resultBuffer;
    }
}

