/*
 * Decompiled with CFR 0.152.
 */
package naga2.packetreader;

import java.nio.ByteBuffer;
import naga2.NIOUtils;
import naga2.PacketReader;
import naga2.exception.ProtocolViolationException;

public class RegularPacketReader
implements PacketReader {
    private final boolean m_bigEndian;
    private final int m_headerSize;

    public RegularPacketReader(int headerSize, boolean bigEndian) {
        if (headerSize < 1 || headerSize > 4) {
            throw new IllegalArgumentException("Header must be between 1 and 4 bytes long.");
        }
        this.m_bigEndian = bigEndian;
        this.m_headerSize = headerSize;
    }

    @Override
    public byte[] nextPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        if (byteBuffer.remaining() < this.m_headerSize) {
            return null;
        }
        byteBuffer.mark();
        int length = NIOUtils.getPacketSizeFromByteBuffer(byteBuffer, this.m_headerSize, this.m_bigEndian);
        if (byteBuffer.remaining() >= length) {
            byte[] packet = new byte[length];
            byteBuffer.get(packet);
            return packet;
        }
        byteBuffer.reset();
        return null;
    }
}

