/*
 * Decompiled with CFR 0.152.
 */
package naga2.packetreader;

import java.nio.ByteBuffer;
import naga2.PacketReader;
import naga2.exception.ProtocolViolationException;

public class DelimiterPacketReader
implements PacketReader {
    private volatile int m_maxPacketSize;
    private byte m_delimiter;

    public DelimiterPacketReader(byte delimiter) {
        this(delimiter, -1);
    }

    public DelimiterPacketReader(byte delimiter, int maxPacketSize) {
        if (maxPacketSize < 1 && maxPacketSize != -1) {
            throw new IllegalArgumentException("Max packet size must be larger that 1, was: " + maxPacketSize);
        }
        this.m_delimiter = delimiter;
        this.m_maxPacketSize = maxPacketSize;
    }

    public int getMaxPacketSize() {
        return this.m_maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.m_maxPacketSize = maxPacketSize;
    }

    @Override
    public byte[] nextPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        byteBuffer.mark();
        int bytesRead = 0;
        while (byteBuffer.remaining() > 0) {
            byte ch = byteBuffer.get();
            if (ch == this.m_delimiter) {
                byte[] packet = new byte[bytesRead];
                byteBuffer.reset();
                byteBuffer.get(packet);
                byteBuffer.get();
                return packet;
            }
            if (this.m_maxPacketSize <= 0 || ++bytesRead <= this.m_maxPacketSize) continue;
            throw new ProtocolViolationException("Packet exceeds max " + this.m_maxPacketSize);
        }
        byteBuffer.reset();
        return null;
    }
}

