/*
 * Decompiled with CFR 0.152.
 */
package naga2.packetreader;

import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import naga2.PacketReader;
import naga2.exception.ProtocolViolationException;

public class CipherPacketReader
implements PacketReader {
    private final Cipher m_cipher;
    private ByteBuffer m_internalBuffer;
    private PacketReader m_reader;

    public CipherPacketReader(Cipher cipher, PacketReader reader) {
        this.m_cipher = cipher;
        this.m_reader = reader;
    }

    public PacketReader getReader() {
        return this.m_reader;
    }

    public void setReader(PacketReader reader) {
        this.m_reader = reader;
    }

    @Override
    public byte[] nextPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        if (this.m_internalBuffer == null) {
            this.m_internalBuffer = ByteBuffer.allocate(this.m_cipher.getOutputSize(byteBuffer.remaining()));
        } else if (byteBuffer.remaining() > 0) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.m_cipher.getOutputSize(byteBuffer.remaining()) + this.m_internalBuffer.remaining());
            newBuffer.put(this.m_internalBuffer);
            this.m_internalBuffer = newBuffer;
        }
        if (byteBuffer.remaining() > 0) {
            try {
                this.m_cipher.update(byteBuffer, this.m_internalBuffer);
            }
            catch (ShortBufferException e) {
                throw new ProtocolViolationException("Short buffer");
            }
            this.m_internalBuffer.flip();
        }
        byte[] packet = this.m_reader.nextPacket(this.m_internalBuffer);
        if (this.m_internalBuffer.remaining() == 0) {
            this.m_internalBuffer = null;
        }
        return packet;
    }
}

