/*
 * Decompiled with CFR 0.152.
 */
package naga2.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.SocketAddress;
import naga2.NIOService;
import naga2.NIOSocket;
import naga2.SocketObserver;
import naga2.packetreader.RegularPacketReader;
import naga2.packetwriter.RegularPacketWriter;

public class ValidationClient {
    ValidationClient() {
    }

    public static void main(String ... args) {
        try {
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            String account = args[2];
            String password = args[3];
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(stream);
            dataStream.writeUTF(account);
            dataStream.writeUTF(password);
            dataStream.flush();
            final byte[] content = stream.toByteArray();
            dataStream.close();
            NIOService service = new NIOService();
            NIOSocket socket = service.openSocket(host, port);
            socket.setPacketReader(new RegularPacketReader(1, true));
            socket.setPacketWriter(new RegularPacketWriter(1, true));
            socket.listen(new SocketObserver(){

                @Override
                public void connectionOpened(NIOSocket nioSocket) {
                    System.out.println("Sending login...");
                    nioSocket.write(content);
                }

                @Override
                public void packetSent(NIOSocket socket, Object tag) {
                    System.out.println("Packet sent");
                }

                @Override
                public void packetReceived(NIOSocket socket, byte[] packet, SocketAddress address) {
                }

                @Override
                public void packetReceived(NIOSocket socket, byte[] packet) {
                    try {
                        String reply = new DataInputStream(new ByteArrayInputStream(packet)).readUTF();
                        System.out.println("Reply was: " + reply);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void connectionBroken(NIOSocket nioSocket, Exception exception) {
                    System.out.println("Connection failed.");
                    System.exit(-1);
                }
            });
            while (true) {
                service.selectBlocking();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

