/*
 * Decompiled with CFR 0.152.
 */
package naga2.examples;

import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import naga2.NIOService;
import naga2.NIOSocket;
import naga2.NIOSocketSSL;
import naga2.SocketObserver;

public class SSLTester {
    public static void main(String ... args) {
        try {
            NIOService service = new NIOService();
            SSLEngine engine = SSLContext.getDefault().createSSLEngine();
            NIOSocket socket = service.openSSLSocket(engine, "www.sslshopper.com", 443);
            socket.listen(new SocketObserver(){

                @Override
                public void packetSent(NIOSocket socket, Object tag) {
                    System.out.println("Packet sent");
                }

                @Override
                public void connectionOpened(NIOSocket nioSocket) {
                    try {
                        ((NIOSocketSSL)nioSocket).beginHandshake();
                    }
                    catch (SSLException e) {
                        e.printStackTrace();
                    }
                    System.out.println("*Connection opened");
                    nioSocket.write("GET /ssl-converter.html HTTP/1.0\r\n\r\n".getBytes());
                }

                @Override
                public void connectionBroken(NIOSocket nioSocket, Exception exception) {
                    System.out.println("*Connection broken");
                    if (exception != null) {
                        exception.printStackTrace();
                    }
                    System.exit(9);
                }

                @Override
                public void packetReceived(NIOSocket socket, byte[] packet, SocketAddress address) {
                }

                @Override
                public void packetReceived(NIOSocket socket, byte[] packet) {
                    System.out.println("*Unencrypted Packet received " + packet.length);
                    System.out.println(new String(packet));
                }
            });
            while (true) {
                service.selectBlocking();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

