/*
 * Decompiled with CFR 0.152.
 */
package naga2.examples;

import java.io.IOException;
import java.net.InetSocketAddress;
import naga2.ConnectionAcceptor;
import naga2.NIOServerSocket;
import naga2.NIOService;
import naga2.NIOSocket;
import naga2.ServerSocketObserverAdapter;
import naga2.SocketObserverAdapter;
import naga2.packetreader.AsciiLinePacketReader;
import naga2.packetwriter.AsciiLinePacketWriter;

public class Rot13Server {
    Rot13Server() {
    }

    public static void main(String ... args) {
        int port = Integer.parseInt(args[0]);
        try {
            NIOService service = new NIOService();
            NIOServerSocket socket = service.openServerSocket(port);
            final byte[] welcomeMessage = ("Welcome to the ROT13 server at " + socket.toString() + "!").getBytes();
            socket.listen(new ServerSocketObserverAdapter(){

                @Override
                public void newConnection(NIOSocket nioSocket) {
                    InetSocketAddress sa = (InetSocketAddress)nioSocket.getRemoteAddress();
                    System.out.println("Client " + sa.getHostName() + " connected.");
                    nioSocket.setPacketReader(new AsciiLinePacketReader());
                    nioSocket.setPacketWriter(new AsciiLinePacketWriter());
                    nioSocket.write(welcomeMessage);
                    nioSocket.listen(new SocketObserverAdapter(){

                        @Override
                        public void packetReceived(NIOSocket socket, byte[] packet) {
                            String line = new String(packet).trim();
                            if (line.equals("+++")) {
                                socket.write("Thank you and good bye.".getBytes());
                                socket.closeAfterWrite();
                                return;
                            }
                            StringBuilder builder = new StringBuilder(line);
                            for (int i = 0; i < builder.length(); ++i) {
                                char c = builder.charAt(i);
                                if (c >= 'a' && c <= 'z') {
                                    builder.setCharAt(i, (char)((c - 97 + 13) % 26 + 97));
                                }
                                if (c < 'A' || c > 'Z') continue;
                                builder.setCharAt(i, (char)((c - 65 + 13) % 26 + 65));
                            }
                            socket.write(builder.toString().getBytes());
                        }

                        @Override
                        public void connectionBroken(NIOSocket nioSocket, Exception exception) {
                            InetSocketAddress sa = (InetSocketAddress)nioSocket.getRemoteAddress();
                            System.out.println("Client " + sa.getHostName() + " disconnected.");
                            if (exception != null) {
                                exception.printStackTrace();
                            }
                        }
                    });
                }
            });
            socket.setConnectionAcceptor(ConnectionAcceptor.ALLOW);
            while (true) {
                service.selectBlocking();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

