/*
 * Decompiled with CFR 0.152.
 */
package naga2.examples;

import java.io.IOException;
import java.net.InetSocketAddress;
import naga2.ConnectionAcceptor;
import naga2.NIOServerSocket;
import naga2.NIOService;
import naga2.NIOSocket;
import naga2.ServerSocketObserverAdapter;
import naga2.SocketObserverAdapter;

public class EchoServer {
    EchoServer() {
    }

    public static void main(String ... args) {
        int port = Integer.parseInt(args[0]);
        try {
            NIOService service = new NIOService();
            NIOServerSocket socket = service.openServerSocket(port);
            socket.listen(new ServerSocketObserverAdapter(){

                @Override
                public void newConnection(NIOSocket nioSocket) {
                    InetSocketAddress sa = (InetSocketAddress)nioSocket.getRemoteAddress();
                    System.out.println("Client " + sa.getHostName() + " connected.");
                    nioSocket.listen(new SocketObserverAdapter(){

                        @Override
                        public void packetReceived(NIOSocket socket, byte[] packet) {
                            socket.write(packet);
                        }

                        @Override
                        public void connectionBroken(NIOSocket nioSocket, Exception exception) {
                            InetSocketAddress sa = (InetSocketAddress)nioSocket.getRemoteAddress();
                            System.out.println("Client " + sa.getHostName() + " disconnected.");
                        }
                    });
                }
            });
            socket.setConnectionAcceptor(ConnectionAcceptor.ALLOW);
            while (true) {
                service.selectBlocking();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

