/*
 * Decompiled with CFR 0.152.
 */
package naga2.examples;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import naga2.ConnectionAcceptor;
import naga2.NIOServerSocket;
import naga2.NIOSocket;
import naga2.ServerSocketObserver;
import naga2.SocketObserver;
import naga2.eventmachine.DelayedEvent;
import naga2.eventmachine.EventMachine;
import naga2.packetreader.AsciiLinePacketReader;
import naga2.packetwriter.AsciiLinePacketWriter;

public class ChatServer
implements ServerSocketObserver {
    private final EventMachine m_eventMachine;
    private final List<User> m_users;

    ChatServer(EventMachine machine) {
        this.m_eventMachine = machine;
        this.m_users = new ArrayList<User>();
    }

    @Override
    public void acceptFailed(IOException exception) {
        System.out.println("Failed to accept connection: " + exception);
    }

    @Override
    public void serverSocketDied(Exception exception) {
        System.out.println("Server socket died.");
        System.exit(-1);
    }

    @Override
    public void newConnection(NIOSocket nioSocket) {
        InetSocketAddress addr = (InetSocketAddress)nioSocket.getRemoteAddress();
        System.out.println("New user connected from " + addr.getHostName() + ".");
        this.m_users.add(new User(this, nioSocket));
    }

    private void removeUser(User user) {
        System.out.println("Removing user " + user + ".");
        this.m_users.remove(user);
    }

    public void broadcast(User sender, String string) {
        byte[] bytesToSend = string.getBytes();
        for (User user : this.m_users) {
            if (user == sender) continue;
            user.sendBroadcast(bytesToSend);
        }
    }

    public static void main(String ... args) {
        int port = Integer.parseInt(args[0]);
        try {
            EventMachine machine = new EventMachine();
            NIOServerSocket socket = machine.getNIOService().openServerSocket(port);
            socket.listen(new ChatServer(machine));
            socket.setConnectionAcceptor(ConnectionAcceptor.ALLOW);
            machine.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public EventMachine getEventMachine() {
        return this.m_eventMachine;
    }

    private static class User
    implements SocketObserver {
        private static final long LOGIN_TIMEOUT = 30000L;
        private static final long INACTIVITY_TIMEOUT = 30000L;
        private final ChatServer m_server;
        private final NIOSocket m_socket;
        private String m_name;
        private DelayedEvent m_disconnectEvent;

        private User(ChatServer server, NIOSocket socket) {
            this.m_server = server;
            this.m_socket = socket;
            this.m_socket.setPacketReader(new AsciiLinePacketReader());
            this.m_socket.setPacketWriter(new AsciiLinePacketWriter());
            this.m_socket.listen(this);
            this.m_name = null;
        }

        @Override
        public void connectionOpened(NIOSocket nioSocket) {
            this.m_disconnectEvent = this.m_server.getEventMachine().executeLater(new Runnable(){

                @Override
                public void run() {
                    User.this.m_socket.write("Disconnecting due to inactivity".getBytes());
                    User.this.m_socket.closeAfterWrite();
                }
            }, 30000L);
            nioSocket.write("Please enter your name:".getBytes());
        }

        public String toString() {
            InetSocketAddress addr = (InetSocketAddress)this.m_socket.getRemoteAddress();
            return this.m_name != null ? this.m_name + "@" + addr.getHostName() : "anon@" + addr.getHostName();
        }

        @Override
        public void connectionBroken(NIOSocket nioSocket, Exception exception) {
            if (this.m_name != null) {
                this.m_server.broadcast(this, this.m_name + " left the chat.");
            }
            this.m_server.removeUser(this);
        }

        private void scheduleInactivityEvent() {
            if (this.m_disconnectEvent != null) {
                this.m_disconnectEvent.cancel();
            }
            this.m_disconnectEvent = this.m_server.getEventMachine().executeLater(new Runnable(){

                @Override
                public void run() {
                    User.this.m_socket.write("Disconnected due to inactivity.".getBytes());
                    User.this.m_socket.closeAfterWrite();
                }
            }, 30000L);
        }

        @Override
        public void packetReceived(NIOSocket socket, byte[] packet, SocketAddress address) {
        }

        @Override
        public void packetReceived(NIOSocket socket, byte[] packet) {
            String message = new String(packet).trim();
            if (message.length() == 0) {
                return;
            }
            this.scheduleInactivityEvent();
            if (this.m_name == null) {
                this.m_name = message;
                System.out.println(this + " logged in.");
                this.m_server.broadcast(this, this.m_name + " has joined the chat.");
                this.m_socket.write(("Welcome " + this.m_name + ". There are " + this.m_server.m_users.size() + " user(s) currently logged in.").getBytes());
                return;
            }
            this.m_server.broadcast(this, this.m_name + ": " + message);
        }

        @Override
        public void packetSent(NIOSocket socket, Object tag) {
        }

        public void sendBroadcast(byte[] bytesToSend) {
            if (this.m_name != null) {
                this.m_socket.write(bytesToSend);
            }
        }
    }
}

