/*
 * Decompiled with CFR 0.152.
 */
package naga2.eventmachine;

import java.io.IOException;
import java.util.Date;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import naga2.ExceptionObserver;
import naga2.NIOService;
import naga2.eventmachine.DelayedAction;
import naga2.eventmachine.DelayedEvent;

public class EventMachine {
    private final NIOService m_service = new NIOService();
    private final Queue<DelayedAction> m_queue = new PriorityBlockingQueue<DelayedAction>();
    private Thread m_runThread = null;

    public void asyncExecute(Runnable runnable) {
        this.executeLater(runnable, 0L);
    }

    public DelayedEvent executeLater(Runnable runnable, long msDelay) {
        return this.queueAction(runnable, msDelay + System.currentTimeMillis());
    }

    private DelayedAction queueAction(Runnable runnable, long time) {
        DelayedAction action = new DelayedAction(runnable, time);
        this.m_queue.add(action);
        this.m_service.wakeup();
        return action;
    }

    public DelayedEvent executeAt(Runnable runnable, Date date) {
        return this.queueAction(runnable, date.getTime());
    }

    public void setObserver(ExceptionObserver observer) {
        this.getNIOService().setExceptionObserver(observer);
    }

    public long timeOfNextEvent() {
        DelayedAction action = this.m_queue.peek();
        return action == null ? Long.MAX_VALUE : action.getTime();
    }

    public synchronized void start() {
        if (this.m_runThread != null) {
            throw new IllegalStateException("Service already running.");
        }
        if (!this.m_service.isOpen()) {
            throw new IllegalStateException("Service has been shut down.");
        }
        this.m_runThread = new Thread(){

            @Override
            public void run() {
                while (EventMachine.this.m_runThread == this) {
                    try {
                        EventMachine.this.select();
                    }
                    catch (Throwable e) {
                        if (EventMachine.this.m_runThread != this) continue;
                        EventMachine.this.getNIOService().notifyException(e);
                    }
                }
            }
        };
        this.m_runThread.start();
    }

    public synchronized void stop() {
        if (this.m_runThread == null) {
            throw new IllegalStateException("Service is not running.");
        }
        this.m_runThread = null;
        this.m_service.wakeup();
    }

    public synchronized void shutdown() {
        if (this.m_runThread == null) {
            throw new IllegalStateException("The service is not running.");
        }
        this.m_service.close();
        this.stop();
    }

    private void select() throws Throwable {
        while (this.timeOfNextEvent() <= System.currentTimeMillis()) {
            try {
                this.runNextAction();
            }
            catch (Throwable t) {
                this.getNIOService().notifyException(t);
            }
        }
        if (this.timeOfNextEvent() == Long.MAX_VALUE) {
            this.m_service.selectBlocking();
        } else {
            long delay = this.timeOfNextEvent() - System.currentTimeMillis();
            this.m_service.selectBlocking(Math.max(1L, delay));
        }
    }

    private void runNextAction() {
        this.m_queue.poll().run();
    }

    public NIOService getNIOService() {
        return this.m_service;
    }

    public Queue<DelayedEvent> getQueue() {
        return new PriorityQueue<DelayedEvent>(this.m_queue);
    }

    public int getQueueSize() {
        return this.m_queue.size();
    }
}

