/*
 * Decompiled with CFR 0.152.
 */
package naga2.eventmachine;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import naga2.eventmachine.DelayedEvent;

class DelayedAction
implements Comparable<DelayedAction>,
DelayedEvent {
    private static final AtomicLong s_nextId = new AtomicLong(0L);
    private volatile Runnable m_call;
    private final long m_time;
    private final long m_id;

    public DelayedAction(Runnable call, long time) {
        this.m_call = call;
        this.m_time = time;
        this.m_id = s_nextId.getAndIncrement();
    }

    @Override
    public void cancel() {
        this.m_call = null;
    }

    void run() {
        Runnable call = this.m_call;
        if (call != null) {
            call.run();
        }
    }

    @Override
    public int compareTo(DelayedAction o) {
        if (this.m_time < o.m_time) {
            return -1;
        }
        if (this.m_time > o.m_time) {
            return 1;
        }
        if (this.m_id < o.m_id) {
            return -1;
        }
        return this.m_id > o.m_id ? 1 : 0;
    }

    @Override
    public Runnable getCall() {
        return this.m_call;
    }

    @Override
    public long getTime() {
        return this.m_time;
    }

    public String toString() {
        return "DelayedAction @ " + new Date(this.m_time) + " [" + (this.m_call == null ? "Cancelled" : this.m_call) + "]";
    }
}

