/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import naga2.NIOService;
import naga2.NIOUtils;
import naga2.SocketReader;

class UdpSocketReader
implements SocketReader {
    private final NIOService m_nioService;
    private ByteBuffer m_previousBytes;
    private long m_bytesRead;
    private InetSocketAddress m_remoteAddr = null;

    UdpSocketReader(NIOService nioService) {
        this.m_nioService = nioService;
        this.m_bytesRead = 0L;
    }

    @Override
    public boolean read(Channel achannel) throws IOException {
        if (!(achannel instanceof DatagramChannel)) {
            throw new IllegalArgumentException("!(channel instanceof " + DatagramChannel.class + ")");
        }
        DatagramChannel channel = (DatagramChannel)achannel;
        ByteBuffer buffer = this.getBuffer();
        buffer.clear();
        if (this.m_previousBytes != null) {
            buffer.position(this.m_previousBytes.remaining());
        }
        int position = buffer.position();
        this.m_remoteAddr = (InetSocketAddress)channel.receive(buffer);
        if (this.m_remoteAddr == null) {
            return false;
        }
        if (!buffer.hasRemaining()) {
            throw new BufferOverflowException();
        }
        int read = buffer.position() - position;
        this.m_bytesRead += (long)read;
        if (read == 0) {
            return false;
        }
        if (this.m_previousBytes != null) {
            position = buffer.position();
            buffer.position(0);
            buffer.put(this.m_previousBytes);
            buffer.position(position);
            this.m_previousBytes = null;
        }
        buffer.flip();
        return read > 0;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.m_remoteAddr;
    }

    @Override
    public void compact() {
        ByteBuffer buffer = this.getBuffer();
        if (buffer.remaining() > 0) {
            this.m_previousBytes = NIOUtils.copy(buffer);
        }
    }

    @Override
    public long getBytesRead() {
        return this.m_bytesRead;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.m_nioService.getSharedBuffer();
    }
}

