/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import naga2.PacketWriter;
import naga2.SocketWriter;
import naga2.packetwriter.RawPacketWriter;

class TcpSocketWriter
implements SocketWriter {
    private long m_bytesWritten = 0L;
    private ByteBuffer[] m_writeBuffers = null;
    private PacketWriter m_packetWriter = RawPacketWriter.INSTANCE;
    private Object m_tag;
    private int m_currentBuffer;

    TcpSocketWriter() {
    }

    @Override
    public PacketWriter getPacketWriter() {
        return this.m_packetWriter;
    }

    @Override
    public void setPacketWriter(PacketWriter packetWriter) {
        this.m_packetWriter = packetWriter;
    }

    @Override
    public boolean isEmpty() {
        return this.m_writeBuffers == null;
    }

    @Override
    public void setPacket(byte[] data, InetSocketAddress addr, Object tag) {
        if (addr != null) {
            throw new IllegalArgumentException("addr must be null");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("This method should only called when m_writeBuffers == null");
        }
        this.m_writeBuffers = this.m_packetWriter.write(new ByteBuffer[]{ByteBuffer.wrap(data)});
        this.m_currentBuffer = 0;
        this.m_tag = tag;
    }

    @Override
    public boolean write(Channel achannel) throws IOException {
        if (!(achannel instanceof SocketChannel)) {
            throw new IllegalArgumentException("!(channel instanceof " + SocketChannel.class + ")");
        }
        SocketChannel channel = (SocketChannel)achannel;
        if (this.m_writeBuffers == null || this.m_currentBuffer == this.m_writeBuffers.length - 1 && !this.m_writeBuffers[this.m_currentBuffer].hasRemaining()) {
            this.m_writeBuffers = null;
            return true;
        }
        long written = channel.write(this.m_writeBuffers, this.m_currentBuffer, this.m_writeBuffers.length - this.m_currentBuffer);
        if (written == 0L) {
            return false;
        }
        this.m_bytesWritten += written;
        for (int i = this.m_currentBuffer; i < this.m_writeBuffers.length; ++i) {
            if (this.m_writeBuffers[i].hasRemaining()) {
                this.m_currentBuffer = i;
                break;
            }
            this.m_writeBuffers[i] = null;
        }
        if (this.m_writeBuffers[this.m_currentBuffer] == null) {
            this.m_writeBuffers = null;
        }
        return true;
    }

    @Override
    public long getBytesWritten() {
        return this.m_bytesWritten;
    }

    @Override
    public Object getTag() {
        return this.m_tag;
    }
}

