/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import naga2.NIOService;
import naga2.NIOUtils;
import naga2.SocketReader;

class TcpSocketReader
implements SocketReader {
    private final NIOService m_nioService;
    private ByteBuffer m_previousBytes;
    private long m_bytesRead;

    TcpSocketReader(NIOService nioService) {
        this.m_nioService = nioService;
        this.m_bytesRead = 0L;
    }

    @Override
    public boolean read(Channel achannel) throws IOException {
        int read;
        if (!(achannel instanceof SocketChannel)) {
            throw new IllegalArgumentException("!(channel instanceof " + SocketChannel.class + ")");
        }
        SocketChannel channel = (SocketChannel)achannel;
        ByteBuffer buffer = this.getBuffer();
        buffer.clear();
        if (this.m_previousBytes != null) {
            buffer.position(this.m_previousBytes.remaining());
        }
        if ((read = channel.read(buffer)) < 0) {
            throw new EOFException("Buffer read -1");
        }
        if (!buffer.hasRemaining()) {
            throw new BufferOverflowException();
        }
        this.m_bytesRead += (long)read;
        if (read == 0) {
            return false;
        }
        if (this.m_previousBytes != null) {
            int position = buffer.position();
            buffer.position(0);
            buffer.put(this.m_previousBytes);
            buffer.position(position);
            this.m_previousBytes = null;
        }
        buffer.flip();
        return read > 0;
    }

    @Override
    public void compact() {
        ByteBuffer buffer = this.getBuffer();
        if (buffer.remaining() > 0) {
            this.m_previousBytes = NIOUtils.copy(buffer);
        }
    }

    @Override
    public long getBytesRead() {
        return this.m_bytesRead;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.m_nioService.getSharedBuffer();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return null;
    }
}

