/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import naga2.ChannelResponder;
import naga2.NIOService;
import naga2.NIOSocket;
import naga2.PacketReader;
import naga2.PacketWriter;
import naga2.SocketObserver;
import naga2.SocketReader;
import naga2.SocketWriter;
import naga2.packetreader.RawPacketReader;

class SocketChannelResponder
extends ChannelResponder
implements NIOSocket {
    private int m_maxQueueSize = -1;
    private long m_timeOpened = -1L;
    private final AtomicLong m_bytesInQueue;
    private ConcurrentLinkedQueue<Object> m_packetQueue;
    private PacketReader m_packetReader = RawPacketReader.INSTANCE;
    private volatile SocketObserver m_socketObserver = null;
    private final SocketReader m_socketReader;
    private final SocketWriter m_socketWriter;

    public SocketChannelResponder(NIOService service, SelectableChannel socketChannel, InetSocketAddress localAddress, InetSocketAddress remoteAddress, SocketReader socketReader, SocketWriter socketWriter) {
        super(service, socketChannel, localAddress, remoteAddress);
        this.m_bytesInQueue = new AtomicLong(0L);
        this.m_packetQueue = new ConcurrentLinkedQueue();
        this.m_socketReader = socketReader;
        this.m_socketWriter = socketWriter;
    }

    @Override
    void keyInitialized() {
        if (!this.isConnected() && this.isConnectable()) {
            this.addInterest(8);
        }
    }

    @Override
    public void closeAfterWrite() {
        this.queue(new Runnable(){

            @Override
            public void run() {
                SocketChannelResponder.this.m_packetQueue.clear();
                SocketChannelResponder.this.close(null);
            }
        });
    }

    @Override
    public void queue(Runnable runnable) {
        this.m_packetQueue.offer(runnable);
        this.getNIOService().queue(new AddInterestEvent(4));
    }

    @Override
    public boolean write(byte[] packet, InetSocketAddress addr, Object tag) {
        long currentQueueSize = this.m_bytesInQueue.addAndGet(packet.length);
        if (this.m_maxQueueSize > 0 && currentQueueSize > (long)this.m_maxQueueSize) {
            this.m_bytesInQueue.addAndGet(-packet.length);
            return false;
        }
        this.m_packetQueue.offer(new Object[]{packet, addr, tag});
        this.getNIOService().queue(new AddInterestEvent(4));
        return true;
    }

    @Override
    public boolean write(byte[] packet, InetSocketAddress addr) {
        return this.write(packet, addr, null);
    }

    @Override
    public boolean write(byte[] packet, Object tag) {
        return this.write(packet, null, tag);
    }

    @Override
    public boolean write(byte[] packet) {
        return this.write(packet, null, null);
    }

    public boolean isConnected() {
        SelectableChannel channel = this.getChannel();
        return channel instanceof SocketChannel && ((SocketChannel)channel).isConnected();
    }

    public boolean isConnectable() {
        SelectableChannel channel = this.getChannel();
        return channel instanceof SocketChannel;
    }

    private void notifyPacketReceived(byte[] packet, SocketAddress remoteAddress) {
        try {
            if (this.m_socketObserver != null) {
                if (remoteAddress != null) {
                    this.m_socketObserver.packetReceived(this, packet, remoteAddress);
                } else {
                    this.m_socketObserver.packetReceived(this, packet);
                }
            }
        }
        catch (Exception e) {
            this.getNIOService().notifyException(e);
        }
    }

    private void notifyPacketSent(Object tag) {
        try {
            if (this.m_socketObserver != null) {
                this.m_socketObserver.packetSent(this, tag);
            }
        }
        catch (Exception e) {
            this.getNIOService().notifyException(e);
        }
    }

    @Override
    public void socketReadyForRead() {
        if (!this.isOpen()) {
            return;
        }
        try {
            if (!this.isConnected() && this.isConnectable()) {
                throw new IOException("Channel not connected.");
            }
            while (this.m_socketReader.read(this.getChannel())) {
                byte[] packet;
                ByteBuffer buffer = this.m_socketReader.getBuffer();
                while (buffer.remaining() > 0 && (packet = this.m_packetReader.nextPacket(buffer)) != null) {
                    if (packet == PacketReader.SKIP_PACKET) continue;
                    this.notifyPacketReceived(packet, this.m_socketReader.getRemoteAddress());
                }
                this.m_socketReader.compact();
            }
        }
        catch (Exception e) {
            this.close(e);
        }
    }

    private InetSocketAddress fillCurrentOutgoingBuffer() throws IOException {
        InetSocketAddress addr = null;
        if (this.m_socketWriter.isEmpty()) {
            Object nextPacket = this.m_packetQueue.poll();
            while (nextPacket != null && nextPacket instanceof Runnable) {
                ((Runnable)nextPacket).run();
                nextPacket = this.m_packetQueue.poll();
            }
            if (nextPacket != null) {
                Object[] dataPacket = null;
                Object tag = null;
                dataPacket = (Object[])nextPacket;
                byte[] data = (byte[])dataPacket[0];
                addr = (InetSocketAddress)dataPacket[1];
                tag = dataPacket[2];
                this.m_socketWriter.setPacket(data, addr, tag);
                this.m_bytesInQueue.addAndGet(-data.length);
            }
        }
        return addr;
    }

    @Override
    public void socketReadyForWrite() {
        try {
            this.deleteInterest(4);
            if (!this.isOpen()) {
                return;
            }
            this.fillCurrentOutgoingBuffer();
            if (this.m_socketWriter.isEmpty()) {
                return;
            }
            while (!this.m_socketWriter.isEmpty()) {
                boolean bytesWereWritten = this.m_socketWriter.write(this.getChannel());
                if (!bytesWereWritten) {
                    this.addInterest(4);
                    return;
                }
                if (!this.m_socketWriter.isEmpty()) continue;
                this.notifyPacketSent(this.m_socketWriter.getTag());
                this.fillCurrentOutgoingBuffer();
            }
        }
        catch (Exception e) {
            this.close(e);
        }
    }

    @Override
    public void socketReadyForConnect() {
        try {
            if (!this.isOpen()) {
                return;
            }
            SelectableChannel channel = this.getChannel();
            if (!(channel instanceof SocketChannel)) {
                return;
            }
            SocketChannel socketChannel = (SocketChannel)channel;
            if (socketChannel.finishConnect()) {
                this.setLocalAddress(socketChannel.socket().getLocalSocketAddress());
                this.deleteInterest(8);
                this.m_timeOpened = System.currentTimeMillis();
                this.notifyObserverOfConnect();
            }
        }
        catch (Exception e) {
            this.close(e);
        }
    }

    public void notifyWasCancelled() {
        this.close();
    }

    @Override
    public long getBytesRead() {
        return this.m_socketReader.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.m_socketWriter.getBytesWritten();
    }

    @Override
    public long getTimeOpen() {
        return this.m_timeOpened > 0L ? System.currentTimeMillis() - this.m_timeOpened : -1L;
    }

    @Override
    public long getWriteQueueSize() {
        return this.m_bytesInQueue.get();
    }

    @Override
    public String toString() {
        try {
            return this.getChannel().toString();
        }
        catch (Exception e) {
            return "Closed NIO Socket";
        }
    }

    @Override
    public int getMaxQueueSize() {
        return this.m_maxQueueSize;
    }

    @Override
    public void setMaxQueueSize(int maxQueueSize) {
        this.m_maxQueueSize = maxQueueSize;
    }

    @Override
    public void listen(SocketObserver socketObserver) {
        this.markObserverSet();
        this.getNIOService().queue(new BeginListenEvent(this, socketObserver == null ? SocketObserver.NULL : socketObserver));
    }

    private void notifyObserverOfConnect() {
        try {
            if (this.m_socketObserver != null) {
                this.m_socketObserver.connectionOpened(this);
            }
        }
        catch (Exception e) {
            this.getNIOService().notifyException(e);
        }
    }

    private void notifyObserverOfDisconnect(Exception exception) {
        try {
            if (this.m_socketObserver != null) {
                this.m_socketObserver.connectionBroken(this, exception);
            }
        }
        catch (Exception e) {
            this.getNIOService().notifyException(e);
        }
    }

    @Override
    public void setPacketReader(PacketReader packetReader) {
        this.m_packetReader = packetReader;
    }

    @Override
    public void setPacketWriter(final PacketWriter packetWriter) {
        if (packetWriter == null) {
            throw new NullPointerException();
        }
        this.queue(new Runnable(){

            @Override
            public void run() {
                SocketChannelResponder.this.m_socketWriter.setPacketWriter(packetWriter);
            }
        });
    }

    @Override
    public SelectableChannel getChannel() {
        return super.getChannel();
    }

    @Override
    protected void shutdown(Exception e) {
        this.m_timeOpened = -1L;
        this.m_packetQueue.clear();
        this.m_bytesInQueue.set(0L);
        this.notifyObserverOfDisconnect(e);
    }

    private class BeginListenEvent
    implements Runnable {
        private final SocketObserver m_newObserver;
        private final SocketChannelResponder m_responder;

        private BeginListenEvent(SocketChannelResponder responder, SocketObserver socketObserver) {
            this.m_responder = responder;
            this.m_newObserver = socketObserver;
        }

        @Override
        public void run() {
            this.m_responder.m_socketObserver = this.m_newObserver;
            if (this.m_responder.isConnected()) {
                this.m_responder.notifyObserverOfConnect();
            }
            if (!this.m_responder.isOpen()) {
                this.m_responder.notifyObserverOfDisconnect(null);
            }
            this.m_responder.addInterest(1);
        }

        public String toString() {
            return "BeginListen[" + this.m_newObserver + "]";
        }
    }

    private class AddInterestEvent
    implements Runnable {
        private final int m_interest;

        private AddInterestEvent(int interest) {
            this.m_interest = interest;
        }

        @Override
        public void run() {
            SocketChannelResponder.this.addInterest(this.m_interest);
        }
    }
}

