/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import naga2.ChannelResponder;
import naga2.ConnectionAcceptor;
import naga2.NIOServerSocket;
import naga2.NIOService;
import naga2.NIOSocket;
import naga2.NIOUtils;
import naga2.ServerSocketObserver;

class ServerSocketChannelResponder
extends ChannelResponder
implements NIOServerSocket {
    private long m_totalRefusedConnections;
    private long m_totalAcceptedConnections;
    private long m_totalFailedConnections;
    private long m_totalConnections;
    private volatile ConnectionAcceptor m_connectionAcceptor;
    private ServerSocketObserver m_observer = null;

    public ServerSocketChannelResponder(NIOService service, ServerSocketChannel channel, InetSocketAddress localAddress) throws IOException {
        super(service, channel, localAddress, null);
        this.setConnectionAcceptor(ConnectionAcceptor.ALLOW);
        this.m_totalRefusedConnections = 0L;
        this.m_totalAcceptedConnections = 0L;
        this.m_totalFailedConnections = 0L;
        this.m_totalConnections = 0L;
    }

    @Override
    public void keyInitialized() {
        this.addInterest(16);
    }

    @Override
    public ServerSocketChannel getChannel() {
        return (ServerSocketChannel)super.getChannel();
    }

    NIOSocket registerSocket(SocketChannel channel, InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws IOException {
        return this.getNIOService().registerSocketChannel(channel, localAddress, remoteAddress);
    }

    private void notifyNewConnection(NIOSocket socket) {
        try {
            if (this.m_observer != null) {
                this.m_observer.newConnection(socket);
            }
        }
        catch (Exception e) {
            this.getNIOService().notifyException(e);
            socket.close();
        }
    }

    private void notifyAcceptFailed(IOException theException) {
        try {
            if (this.m_observer != null) {
                this.m_observer.acceptFailed(theException);
            }
        }
        catch (Exception e) {
            this.getNIOService().notifyException(e);
        }
    }

    @Override
    public void socketReadyForAccept() {
        ++this.m_totalConnections;
        SocketChannel socketChannel = null;
        try {
            socketChannel = this.getChannel().accept();
            if (socketChannel == null) {
                --this.m_totalConnections;
                return;
            }
            InetSocketAddress address = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
            if (!this.m_connectionAcceptor.acceptConnection(address)) {
                ++this.m_totalRefusedConnections;
                NIOUtils.closeChannelSilently(socketChannel);
                return;
            }
            this.notifyNewConnection(this.registerSocket(socketChannel, (InetSocketAddress)socketChannel.socket().getLocalSocketAddress(), address));
            ++this.m_totalAcceptedConnections;
        }
        catch (IOException e) {
            NIOUtils.closeChannelSilently(socketChannel);
            ++this.m_totalFailedConnections;
            this.notifyAcceptFailed(e);
        }
    }

    public void notifyWasCancelled() {
        this.close();
    }

    @Override
    public long getTotalRefusedConnections() {
        return this.m_totalRefusedConnections;
    }

    @Override
    public long getTotalConnections() {
        return this.m_totalConnections;
    }

    @Override
    public long getTotalFailedConnections() {
        return this.m_totalFailedConnections;
    }

    @Override
    public long getTotalAcceptedConnections() {
        return this.m_totalAcceptedConnections;
    }

    @Override
    public void setConnectionAcceptor(ConnectionAcceptor connectionAcceptor) {
        this.m_connectionAcceptor = connectionAcceptor == null ? ConnectionAcceptor.DENY : connectionAcceptor;
    }

    private void notifyObserverSocketDied(Exception exception) {
        try {
            if (this.m_observer != null) {
                this.m_observer.serverSocketDied(exception);
            }
        }
        catch (Exception e) {
            this.getNIOService().notifyException(e);
        }
    }

    @Override
    public void listen(ServerSocketObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.markObserverSet();
        this.getNIOService().queue(new BeginListenEvent(observer));
    }

    @Override
    protected void shutdown(Exception e) {
        this.notifyObserverSocketDied(e);
    }

    private class BeginListenEvent
    implements Runnable {
        private final ServerSocketObserver m_newObserver;

        private BeginListenEvent(ServerSocketObserver socketObserver) {
            this.m_newObserver = socketObserver;
        }

        @Override
        public void run() {
            ServerSocketChannelResponder.this.m_observer = this.m_newObserver;
            if (!ServerSocketChannelResponder.this.isOpen()) {
                ServerSocketChannelResponder.this.notifyObserverSocketDied(null);
                return;
            }
            ServerSocketChannelResponder.this.addInterest(16);
        }

        public String toString() {
            return "BeginListen[" + this.m_newObserver + "]";
        }
    }
}

