/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import naga2.NIOService;
import naga2.NIOSocket;
import naga2.NIOSocketSSL;
import naga2.PacketReader;
import naga2.PacketWriter;
import naga2.SSLPacketHandler;
import naga2.SocketObserver;

class SSLSocketChannelResponder
implements NIOSocketSSL,
SocketObserver {
    private final NIOSocket m_wrappedSocket;
    private final SSLPacketHandler m_packetHandler;
    private final NIOService m_nioService;
    private SocketObserver m_observer;

    public SSLSocketChannelResponder(NIOService nioService, NIOSocket wrappedSocket, SSLEngine engine, boolean client) throws SSLException {
        this.m_nioService = nioService;
        this.m_wrappedSocket = wrappedSocket;
        this.m_packetHandler = new SSLPacketHandler(engine, this.m_wrappedSocket, this);
        this.m_wrappedSocket.setPacketReader(this.m_packetHandler);
        this.m_wrappedSocket.setPacketWriter(this.m_packetHandler);
        engine.setUseClientMode(client);
    }

    @Override
    public void beginHandshake() throws SSLException {
        if (this.getSSLEngine().getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            throw new IllegalStateException("Tried to start handshake during handshake.");
        }
        this.m_packetHandler.begin();
    }

    @Override
    public boolean isEncrypted() {
        return this.m_packetHandler.isEncrypted();
    }

    @Override
    public SSLEngine getSSLEngine() {
        return this.m_packetHandler.getSSLEngine();
    }

    @Override
    public boolean write(byte[] packet) {
        return this.m_wrappedSocket.write(packet);
    }

    @Override
    public boolean write(byte[] packet, Object tag) {
        return this.write(packet, null, tag);
    }

    @Override
    public boolean write(byte[] packet, InetSocketAddress addr) {
        return this.write(packet, addr);
    }

    @Override
    public boolean write(byte[] packet, InetSocketAddress addr, Object tag) {
        return this.m_wrappedSocket.write(packet, addr, tag);
    }

    @Override
    public void queue(Runnable runnable) {
        this.m_wrappedSocket.queue(runnable);
    }

    @Override
    public long getBytesRead() {
        return this.m_wrappedSocket.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.m_wrappedSocket.getBytesWritten();
    }

    @Override
    public long getTimeOpen() {
        return this.m_wrappedSocket.getTimeOpen();
    }

    @Override
    public long getWriteQueueSize() {
        return this.m_wrappedSocket.getWriteQueueSize();
    }

    @Override
    public int getMaxQueueSize() {
        return this.m_wrappedSocket.getMaxQueueSize();
    }

    @Override
    public void setMaxQueueSize(int maxQueueSize) {
        this.m_wrappedSocket.setMaxQueueSize(maxQueueSize);
    }

    @Override
    public void setPacketReader(PacketReader packetReader) {
        this.m_packetHandler.setReader(packetReader);
    }

    @Override
    public void setPacketWriter(final PacketWriter packetWriter) {
        this.m_wrappedSocket.queue(new Runnable(){

            @Override
            public void run() {
                SSLSocketChannelResponder.this.m_packetHandler.setWriter(packetWriter);
            }
        });
    }

    @Override
    public void listen(SocketObserver socketObserver) {
        this.m_observer = socketObserver;
        this.m_wrappedSocket.listen(this);
    }

    @Override
    public void closeAfterWrite() {
        this.m_packetHandler.closeEngine();
        this.m_wrappedSocket.closeAfterWrite();
    }

    @Override
    public void close() {
        this.m_wrappedSocket.close();
    }

    @Override
    public boolean isOpen() {
        return this.m_wrappedSocket.isOpen();
    }

    @Override
    public Object getTag() {
        return this.m_wrappedSocket.getTag();
    }

    @Override
    public void setTag(Object tag) {
        this.m_wrappedSocket.setTag(tag);
    }

    void closeDueToSSLException(SSLException e) {
        try {
            if (this.m_observer != null) {
                this.m_observer.connectionBroken(this, e);
            }
        }
        catch (Exception ex) {
            this.m_nioService.notifyException(e);
        }
        this.m_wrappedSocket.close();
    }

    @Override
    public void connectionOpened(NIOSocket nioSocket) {
        try {
            if (this.m_observer != null) {
                this.m_observer.connectionOpened(this);
            }
        }
        catch (Exception e) {
            this.m_nioService.notifyException(e);
        }
    }

    @Override
    public void connectionBroken(NIOSocket nioSocket, Exception exception) {
        try {
            if (this.m_observer != null) {
                this.m_observer.connectionBroken(this, exception);
            }
        }
        catch (Exception e) {
            this.m_nioService.notifyException(e);
        }
    }

    @Override
    public void packetReceived(NIOSocket socket, byte[] packet, SocketAddress address) {
    }

    @Override
    public void packetReceived(NIOSocket socket, byte[] packet) {
        try {
            if (this.m_observer != null) {
                this.m_observer.packetReceived(this, packet);
            }
        }
        catch (Exception e) {
            this.m_nioService.notifyException(e);
        }
    }

    @Override
    public void packetSent(NIOSocket socket, Object tag) {
        try {
            if (this.m_observer != null) {
                this.m_observer.packetSent(this, tag);
            }
        }
        catch (Exception e) {
            this.m_nioService.notifyException(e);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.m_wrappedSocket.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.m_wrappedSocket.getLocalAddress();
    }
}

