/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import naga2.NIOSocket;
import naga2.NIOUtils;
import naga2.PacketReader;
import naga2.PacketWriter;
import naga2.SSLSocketChannelResponder;
import naga2.exception.ProtocolViolationException;
import naga2.packetreader.RawPacketReader;
import naga2.packetwriter.RawPacketWriter;

public class SSLPacketHandler
implements PacketReader,
PacketWriter {
    private static final Executor TASK_HANDLER = Executors.newSingleThreadExecutor();
    private static final ThreadLocal<ByteBuffer> SSL_BUFFER = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(65536);
        }
    };
    private final SSLEngine m_engine;
    private PacketReader m_reader;
    private PacketWriter m_writer;
    private ByteBuffer m_partialIncomingBuffer;
    private ByteBuffer[] m_initialOutBuffer;
    private final NIOSocket m_socket;
    private final SSLSocketChannelResponder m_responder;
    private boolean m_sslInitiated;

    public SSLPacketHandler(SSLEngine engine, NIOSocket socket, SSLSocketChannelResponder responder) {
        this.m_engine = engine;
        this.m_socket = socket;
        this.m_partialIncomingBuffer = null;
        this.m_writer = RawPacketWriter.INSTANCE;
        this.m_reader = RawPacketReader.INSTANCE;
        this.m_responder = responder;
        this.m_sslInitiated = false;
    }

    public PacketReader getReader() {
        return this.m_reader;
    }

    public void setReader(PacketReader reader) {
        this.m_reader = reader;
    }

    public PacketWriter getWriter() {
        return this.m_writer;
    }

    public void setWriter(PacketWriter writer) {
        this.m_writer = writer;
    }

    private void queueSSLTasks() {
        Runnable task;
        if (!this.m_sslInitiated) {
            return;
        }
        int tasksScheduled = 0;
        while ((task = this.m_engine.getDelegatedTask()) != null) {
            TASK_HANDLER.execute(task);
            ++tasksScheduled;
        }
        if (tasksScheduled == 0) {
            return;
        }
        TASK_HANDLER.execute(new Runnable(){

            @Override
            public void run() {
                SSLPacketHandler.this.m_socket.queue(new Runnable(){

                    @Override
                    public void run() {
                        SSLPacketHandler.this.reactToHandshakeStatus(SSLPacketHandler.this.m_engine.getHandshakeStatus());
                    }
                });
            }
        });
    }

    @Override
    public byte[] nextPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        if (!this.m_sslInitiated) {
            return this.m_reader.nextPacket(byteBuffer);
        }
        try {
            ByteBuffer targetBuffer = SSL_BUFFER.get();
            targetBuffer.clear();
            SSLEngineResult result = this.m_engine.unwrap(byteBuffer, targetBuffer);
            switch (result.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    return null;
                }
                case BUFFER_OVERFLOW: {
                    throw new ProtocolViolationException("SSL Buffer Overflow");
                }
                case CLOSED: {
                    this.m_responder.connectionBroken(this.m_socket, new EOFException("SSL Connection closed"));
                    return null;
                }
            }
            this.reactToHandshakeStatus(result.getHandshakeStatus());
            return this.retrieveDecryptedPacket(targetBuffer);
        }
        catch (SSLException e) {
            this.m_responder.closeDueToSSLException(e);
            return null;
        }
    }

    private void reactToHandshakeStatus(SSLEngineResult.HandshakeStatus status) {
        if (!this.m_sslInitiated) {
            return;
        }
        switch (status) {
            case NOT_HANDSHAKING: 
            case NEED_UNWRAP: {
                break;
            }
            case NEED_TASK: {
                this.queueSSLTasks();
                break;
            }
            case FINISHED: {
                this.m_socket.write(new byte[0]);
                break;
            }
            case NEED_WRAP: {
                this.m_socket.write(new byte[0]);
            }
        }
    }

    private byte[] retrieveDecryptedPacket(ByteBuffer targetBuffer) throws ProtocolViolationException {
        targetBuffer.flip();
        this.m_partialIncomingBuffer = NIOUtils.join(this.m_partialIncomingBuffer, targetBuffer);
        if (this.m_partialIncomingBuffer == null || this.m_partialIncomingBuffer.remaining() == 0) {
            return SKIP_PACKET;
        }
        return this.m_reader.nextPacket(this.m_partialIncomingBuffer);
    }

    @Override
    public ByteBuffer[] write(ByteBuffer[] byteBuffers) {
        if (!this.m_sslInitiated) {
            return this.m_writer.write(byteBuffers);
        }
        if (this.m_engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (!NIOUtils.isEmpty(byteBuffers)) {
                this.m_initialOutBuffer = NIOUtils.concat(this.m_initialOutBuffer, this.m_writer.write(byteBuffers));
                byteBuffers = new ByteBuffer[]{};
            }
            ByteBuffer buffer = SSL_BUFFER.get();
            ByteBuffer[] buffers = null;
            try {
                SSLEngineResult result = null;
                while (this.m_engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    buffer.clear();
                    result = this.m_engine.wrap(byteBuffers, buffer);
                    buffer.flip();
                    buffers = NIOUtils.concat(buffers, NIOUtils.copy(buffer));
                }
                if (result == null) {
                    return null;
                }
                if (result.getStatus() != SSLEngineResult.Status.OK) {
                    throw new SSLException("Unexpectedly not ok wrapping handshake data, was " + (Object)((Object)result.getStatus()));
                }
                this.reactToHandshakeStatus(result.getHandshakeStatus());
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
            return buffers;
        }
        ByteBuffer buffer = SSL_BUFFER.get();
        buffer.clear();
        if (NIOUtils.isEmpty(byteBuffers)) {
            if (this.m_initialOutBuffer == null) {
                return null;
            }
        } else {
            byteBuffers = this.m_writer.write(byteBuffers);
        }
        if (this.m_initialOutBuffer != null) {
            byteBuffers = NIOUtils.concat(this.m_initialOutBuffer, byteBuffers);
            this.m_initialOutBuffer = null;
        }
        ByteBuffer[] encrypted = null;
        while (!NIOUtils.isEmpty(byteBuffers)) {
            buffer.clear();
            try {
                this.m_engine.wrap(byteBuffers, buffer);
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
            buffer.flip();
            encrypted = NIOUtils.concat(encrypted, NIOUtils.copy(buffer));
        }
        return encrypted;
    }

    public SSLEngine getSSLEngine() {
        return this.m_engine;
    }

    void begin() throws SSLException {
        this.m_engine.beginHandshake();
        this.m_sslInitiated = true;
        this.reactToHandshakeStatus(this.m_engine.getHandshakeStatus());
    }

    public void closeEngine() {
        if (!this.m_sslInitiated) {
            return;
        }
        this.m_engine.closeOutbound();
        this.m_responder.write(new byte[0]);
    }

    public boolean isEncrypted() {
        return this.m_sslInitiated;
    }
}

