/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import naga2.ChannelResponder;
import naga2.ExceptionObserver;
import naga2.NIOServerSocket;
import naga2.NIOServerSocketSSL;
import naga2.NIOSocket;
import naga2.NIOSocketSSL;
import naga2.NIOUtils;
import naga2.SSLServerSocketChannelResponder;
import naga2.SSLSocketChannelResponder;
import naga2.ServerSocketChannelResponder;
import naga2.SocketChannelResponder;
import naga2.TcpSocketReader;
import naga2.TcpSocketWriter;
import naga2.UdpSocketReader;
import naga2.UdpSocketWriter;

public class NIOService {
    public static final int DEFAULT_IO_BUFFER_SIZE = 65536;
    private final Selector m_selector = Selector.open();
    private final Queue<Runnable> m_internalEventQueue = new ConcurrentLinkedQueue<Runnable>();
    private ByteBuffer m_sharedBuffer;
    private ExceptionObserver m_exceptionObserver = ExceptionObserver.DEFAULT;

    public NIOService() throws IOException {
        this(65536);
    }

    public NIOService(int ioBufferSize) throws IOException {
        this.setBufferSize(ioBufferSize);
    }

    public synchronized void selectBlocking() throws IOException {
        this.executeQueue();
        if (this.m_selector.select() > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public synchronized void selectNonBlocking() throws IOException {
        this.executeQueue();
        if (this.m_selector.selectNow() > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public synchronized void selectBlocking(long timeout) throws IOException {
        this.executeQueue();
        if (this.m_selector.select(timeout) > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public NIOSocket openSocket(String host, int port) throws IOException {
        return this.openSocket(InetAddress.getByName(host), port);
    }

    public NIOSocket openSSLSocket(SSLEngine sslEngine, String host, int port) throws IOException {
        return this.openSSLSocket(sslEngine, InetAddress.getByName(host), port);
    }

    public NIOSocket openSocket(InetAddress inetAddress, int port) throws IOException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        channel.configureBlocking(false);
        InetSocketAddress address = new InetSocketAddress(inetAddress, port);
        channel.connect(address);
        return this.registerSocketChannel(channel, (InetSocketAddress)socket.getLocalSocketAddress(), address);
    }

    public NIOSocketSSL openSSLSocket(SSLEngine sslEngine, InetAddress inetAddress, int port) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        InetSocketAddress address = new InetSocketAddress(inetAddress, port);
        channel.connect(address);
        return new SSLSocketChannelResponder(this, this.registerSocketChannel(channel, (InetSocketAddress)channel.socket().getLocalSocketAddress(), address), sslEngine, true);
    }

    public NIOServerSocket openServerSocket(int port, int backlog) throws IOException {
        return this.openServerSocket(new InetSocketAddress(port), backlog);
    }

    public NIOServerSocketSSL openSSLServerSocket(SSLContext sslContext, int port, int backlog) throws IOException {
        return this.openSSLServerSocket(sslContext, new InetSocketAddress(port), backlog);
    }

    public NIOServerSocket openServerSocket(int port) throws IOException {
        return this.openServerSocket(port, -1);
    }

    public NIOServerSocketSSL openSSLServerSocket(SSLContext sslContext, int port) throws IOException {
        return this.openSSLServerSocket(sslContext, port, -1);
    }

    public NIOServerSocketSSL openSSLServerSocket(SSLContext sslContext, InetSocketAddress address, int backlog) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.socket().setReuseAddress(true);
        channel.socket().bind(address, backlog);
        channel.configureBlocking(false);
        SSLServerSocketChannelResponder channelResponder = new SSLServerSocketChannelResponder(sslContext, this, channel, address);
        this.queue(new RegisterChannelEvent(channelResponder));
        return channelResponder;
    }

    public NIOServerSocket openServerSocket(InetSocketAddress address, int backlog) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.socket().setReuseAddress(true);
        channel.socket().bind(address, backlog);
        channel.configureBlocking(false);
        ServerSocketChannelResponder channelResponder = new ServerSocketChannelResponder(this, channel, address);
        this.queue(new RegisterChannelEvent(channelResponder));
        return channelResponder;
    }

    public NIOSocket openDatagramSocket(InetAddress inetAddress, int port) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        InetSocketAddress address = new InetSocketAddress(inetAddress, port);
        DatagramSocket socket = channel.socket();
        channel.connect(address);
        channel.configureBlocking(false);
        return this.registerDatagramChannel(channel, (InetSocketAddress)socket.getLocalSocketAddress(), address);
    }

    public NIOSocket openDatagramSocket(String host, int port) throws IOException {
        return this.openDatagramSocket(InetAddress.getByName(host), port);
    }

    public NIOSocket openDatagramSocket() throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        InetSocketAddress addr = new InetSocketAddress("192.168.77.166", 0);
        DatagramSocket socket = channel.socket();
        socket.bind(addr);
        channel.configureBlocking(false);
        return this.registerDatagramChannel(channel, (InetSocketAddress)socket.getLocalSocketAddress(), null);
    }

    public NIOSocket openDatagramServerSocket(InetSocketAddress address) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        DatagramSocket socket = channel.socket();
        socket.setReuseAddress(true);
        socket.bind(address);
        channel.configureBlocking(false);
        SocketChannelResponder channelResponder = new SocketChannelResponder(this, channel, address, null, new UdpSocketReader(this), new UdpSocketWriter());
        this.queue(new RegisterChannelEvent(channelResponder));
        return channelResponder;
    }

    public SocketChannelResponder openDatagramServerSocket2(InetSocketAddress address, List<InetAddress> groups) throws IOException {
        List<NetworkInterface> intfs = null;
        InetAddress inetAddr = address.getAddress();
        MulticastSocket socket = new MulticastSocket(1901);
        if (inetAddr.isAnyLocalAddress()) {
            Enumeration<NetworkInterface> enums = NetworkInterface.getNetworkInterfaces();
            if (enums != null) {
                intfs = Collections.list(enums);
            }
        } else {
            NetworkInterface intf = NetworkInterface.getByInetAddress(inetAddr);
            if (intf != null) {
                intfs = Collections.singletonList(intf);
            }
        }
        if (intfs == null || intfs.size() == 0) {
            throw new RuntimeException("Can't get interface for address: " + inetAddr);
        }
        socket.setReuseAddress(true);
        socket.setBroadcast(true);
        for (InetAddress group : groups) {
            for (NetworkInterface ni : intfs) {
                socket.joinGroup(new InetSocketAddress(group, 0), ni);
            }
        }
        for (NetworkInterface ni : intfs) {
            socket.setNetworkInterface(ni);
        }
        SocketChannelResponder channelResponder = new SocketChannelResponder(this, null, address, null, new UdpSocketReader(this), new UdpSocketWriter());
        this.queue(new RegisterChannelEvent(channelResponder));
        return channelResponder;
    }

    NIOSocket registerSocketChannel(SelectableChannel socketChannel, InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws IOException {
        socketChannel.configureBlocking(false);
        SocketChannelResponder channelResponder = new SocketChannelResponder(this, socketChannel, localAddress, remoteAddress, new TcpSocketReader(this), new TcpSocketWriter());
        this.queue(new RegisterChannelEvent(channelResponder));
        return channelResponder;
    }

    NIOSocket registerDatagramChannel(SelectableChannel datagramChannel, InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws IOException {
        datagramChannel.configureBlocking(false);
        SocketChannelResponder channelResponder = new SocketChannelResponder(this, datagramChannel, localAddress, remoteAddress, new UdpSocketReader(this), new UdpSocketWriter());
        this.queue(new RegisterChannelEvent(channelResponder));
        return channelResponder;
    }

    private void executeQueue() {
        Runnable event;
        while ((event = this.m_internalEventQueue.poll()) != null) {
            try {
                event.run();
            }
            catch (Throwable t) {
                this.notifyException(t);
            }
        }
    }

    private void handleSelectedKeys() {
        Iterator<SelectionKey> it = this.m_selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            try {
                this.handleKey(key);
            }
            catch (Throwable t) {
                this.notifyException(t);
            }
        }
    }

    public void setBufferSize(int newBufferSize) {
        if (newBufferSize < 256) {
            throw new IllegalArgumentException("The buffer must at least hold 256 bytes");
        }
        this.m_sharedBuffer = ByteBuffer.allocate(newBufferSize);
    }

    public int getBufferSize() {
        return this.m_sharedBuffer.capacity();
    }

    ByteBuffer getSharedBuffer() {
        return this.m_sharedBuffer;
    }

    private void handleKey(SelectionKey key) {
        ChannelResponder responder = (ChannelResponder)key.attachment();
        try {
            if (key.isReadable()) {
                responder.socketReadyForRead();
            }
            if (key.isWritable()) {
                responder.socketReadyForWrite();
            }
            if (key.isAcceptable()) {
                responder.socketReadyForAccept();
            }
            if (key.isConnectable()) {
                responder.socketReadyForConnect();
            }
        }
        catch (CancelledKeyException e) {
            responder.close(e);
        }
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.queue(new ShutdownEvent());
    }

    public boolean isOpen() {
        return this.m_selector.isOpen();
    }

    public void queue(Runnable event) {
        this.m_internalEventQueue.add(event);
        this.wakeup();
    }

    public Queue<Runnable> getQueue() {
        return new LinkedList<Runnable>(this.m_internalEventQueue);
    }

    public void wakeup() {
        this.m_selector.wakeup();
    }

    public void setExceptionObserver(ExceptionObserver exceptionObserver) {
        final ExceptionObserver newExceptionObserver = exceptionObserver == null ? ExceptionObserver.DEFAULT : exceptionObserver;
        this.queue(new Runnable(){

            @Override
            public void run() {
                NIOService.this.m_exceptionObserver = newExceptionObserver;
            }
        });
    }

    public void notifyException(Throwable t) {
        try {
            this.m_exceptionObserver.notifyExceptionThrown(t);
        }
        catch (Exception e) {
            System.err.println("Failed to log the following exception to the exception observer:");
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private class ShutdownEvent
    implements Runnable {
        private ShutdownEvent() {
        }

        @Override
        public void run() {
            if (!NIOService.this.isOpen()) {
                return;
            }
            for (SelectionKey key : NIOService.this.m_selector.keys()) {
                try {
                    NIOUtils.cancelKeySilently(key);
                    ((ChannelResponder)key.attachment()).close();
                }
                catch (Exception exception) {}
            }
            try {
                NIOService.this.m_selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class RegisterChannelEvent
    implements Runnable {
        private final ChannelResponder m_channelResponder;

        private RegisterChannelEvent(ChannelResponder channelResponder) {
            this.m_channelResponder = channelResponder;
        }

        @Override
        public void run() {
            try {
                SelectionKey key = this.m_channelResponder.getChannel().register(NIOService.this.m_selector, this.m_channelResponder.getChannel().validOps());
                this.m_channelResponder.setKey(key);
                key.attach(this.m_channelResponder);
            }
            catch (Exception e) {
                this.m_channelResponder.close(e);
            }
        }

        public String toString() {
            return "Register[" + this.m_channelResponder + "]";
        }
    }
}

