/*
 * Decompiled with CFR 0.152.
 */
package naga2;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import naga2.NIOAbstractSocket;
import naga2.NIOService;
import naga2.NIOUtils;

abstract class ChannelResponder
implements NIOAbstractSocket {
    private final NIOService m_service;
    private SocketAddress m_localAddress;
    private SocketAddress m_remoteAddress;
    private final SelectableChannel m_channel;
    private volatile boolean m_open;
    private volatile SelectionKey m_key;
    private volatile int m_interestOps;
    private boolean m_observerSet;
    private Object m_tag;

    protected ChannelResponder(NIOService service, SelectableChannel channel, InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        this.m_channel = channel;
        this.m_service = service;
        this.m_open = true;
        this.m_key = null;
        this.m_interestOps = 0;
        this.m_observerSet = false;
        this.m_localAddress = localAddress;
        this.m_remoteAddress = remoteAddress;
        this.m_tag = null;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.m_remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.m_localAddress;
    }

    public void setLocalAddress(SocketAddress localAddress) {
        this.m_localAddress = localAddress;
    }

    @Override
    public void setTag(Object tag) {
        this.m_tag = tag;
    }

    @Override
    public Object getTag() {
        return this.m_tag;
    }

    protected NIOService getNIOService() {
        return this.m_service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markObserverSet() {
        ChannelResponder channelResponder = this;
        synchronized (channelResponder) {
            if (this.m_observerSet) {
                throw new IllegalStateException("Listener already set.");
            }
            this.m_observerSet = true;
        }
    }

    void socketReadyForRead() {
        throw new UnsupportedOperationException(this.getClass() + " does not support read.");
    }

    void socketReadyForWrite() {
        throw new UnsupportedOperationException(this.getClass() + " does not support write.");
    }

    void socketReadyForAccept() {
        throw new UnsupportedOperationException(this.getClass() + " does not support accept.");
    }

    void socketReadyForConnect() {
        throw new UnsupportedOperationException(this.getClass() + " does not support connect.");
    }

    protected SelectableChannel getChannel() {
        return this.m_channel;
    }

    void setKey(SelectionKey key) {
        if (this.m_key != null) {
            throw new IllegalStateException("Tried to set selection key twice");
        }
        this.m_key = key;
        if (!this.isOpen()) {
            NIOUtils.cancelKeySilently(this.m_key);
            return;
        }
        this.keyInitialized();
        this.synchronizeKeyInterestOps();
    }

    protected SelectionKey getKey() {
        return this.m_key;
    }

    abstract void keyInitialized();

    @Override
    public boolean isOpen() {
        return this.m_open;
    }

    @Override
    public void close() {
        this.close(null);
    }

    protected void close(Exception exception) {
        if (this.isOpen()) {
            this.getNIOService().queue(new CloseEvent(this, exception));
        }
    }

    private void synchronizeKeyInterestOps() {
        if (this.m_key != null) {
            try {
                int oldOps = this.m_key.interestOps();
                if ((this.m_interestOps & 8) != 0) {
                    this.m_key.interestOps(8);
                } else {
                    this.m_key.interestOps(this.m_interestOps);
                }
                if (this.m_key.interestOps() != oldOps) {
                    this.m_service.wakeup();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    protected void deleteInterest(int interest) {
        this.m_interestOps &= ~interest;
        this.synchronizeKeyInterestOps();
    }

    protected void addInterest(int interest) {
        this.m_interestOps |= interest;
        this.synchronizeKeyInterestOps();
    }

    public String toString() {
        return "[" + this.m_localAddress + ", " + this.m_remoteAddress + "]";
    }

    protected abstract void shutdown(Exception var1);

    private static class CloseEvent
    implements Runnable {
        private final ChannelResponder m_responder;
        private final Exception m_exception;

        private CloseEvent(ChannelResponder responder, Exception e) {
            this.m_responder = responder;
            this.m_exception = e;
        }

        @Override
        public void run() {
            if (this.m_responder.isOpen()) {
                this.m_responder.m_open = false;
                NIOUtils.closeKeyAndChannelSilently(this.m_responder.getKey(), this.m_responder.getChannel());
                this.m_responder.shutdown(this.m_exception);
            }
        }
    }
}

