/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.configuration.ui;

import com.ez.workspace.configuration.ui.ConfigurationDiff;
import com.ez.workspace.configuration.ui.ConfigurationDiffListener;
import com.ez.workspace.configuration.ui.ConfigurationModel;
import com.ez.workspace.configuration.ui.Result;
import com.ez.workspace.configuration.ui.ResultEvent;
import com.ez.workspace.configuration.ui.internal.Messages;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ConfigurationDiffList
extends Composite {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    LinkedList<ConfigurationDiff> children;
    LinkedList<ConfigurationModel> model;
    Result result;
    Set<ConfigurationDiffListener> listeners = new HashSet<ConfigurationDiffListener>();
    ScrolledComposite scroller;
    Composite contentPanel;

    public ConfigurationDiffList(Composite parent, int style) {
        super(parent, style);
        this.model = new LinkedList();
        this.children = new LinkedList();
        GridLayout l = new GridLayout(1, false);
        this.setLayout((Layout)l);
        Composite header = this.createHeader(this);
        GridData d = new GridData(4);
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        header.setLayoutData((Object)d);
        this.scroller = new ScrolledComposite((Composite)this, 512);
        this.contentPanel = this.createContent((Composite)this.scroller);
        this.scroller.setBackground(this.getDisplay().getSystemColor(6));
        this.scroller.setContent((Control)this.contentPanel);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        d = new GridData(4);
        d.grabExcessVerticalSpace = true;
        d.verticalAlignment = 4;
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        this.scroller.setLayoutData((Object)d);
        Composite footer = this.createFooter(this);
        d = new GridData(4);
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        footer.setLayoutData((Object)d);
    }

    public void addResultListener(ConfigurationDiffListener l) {
        this.listeners.add(l);
    }

    public void removeResultListener(ConfigurationDiffListener l) {
        this.listeners.remove(l);
    }

    public void addModel(ConfigurationModel m) {
        this.model.add(m);
    }

    public void populate() {
        LinkedList<ConfigurationModel> asapModel = new LinkedList<ConfigurationModel>();
        LinkedList<ConfigurationModel> laterModel = new LinkedList<ConfigurationModel>();
        for (ConfigurationModel m : this.model) {
            if (m.getApplyAsap()) {
                asapModel.add(m);
                continue;
            }
            laterModel.add(m);
        }
        this.createContent1(this.contentPanel, asapModel, laterModel);
        for (ConfigurationDiff c : this.children) {
            c.populate();
        }
        this.scroller.setMinSize(this.contentPanel.computeSize(-1, -1));
    }

    private Composite createContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        return content;
    }

    private void createContent1(Composite content, LinkedList<ConfigurationModel> asapModel, LinkedList<ConfigurationModel> laterModel) {
        GridData d;
        Control[] children = content.getChildren();
        if (children != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
        }
        this.children.clear();
        content.setLayout((Layout)new GridLayout(1, true));
        if (asapModel.size() > 0) {
            d = new GridData();
            Composite group1 = this.createGroup(content, asapModel, Messages.getString(ConfigurationDiffList.class, "later.group"));
            d.grabExcessHorizontalSpace = true;
            d.horizontalAlignment = 4;
            group1.setLayoutData((Object)d);
        }
        if (laterModel.size() > 0) {
            d = new GridData();
            Composite group2 = this.createGroup(content, laterModel, Messages.getString(ConfigurationDiffList.class, "later.group"));
            d.grabExcessHorizontalSpace = true;
            d.horizontalAlignment = 4;
            group2.setLayoutData((Object)d);
        }
        content.layout();
    }

    private Composite createGroup(Composite parent, LinkedList<ConfigurationModel> model, String label) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, true));
        Label l = new Label(content, 0);
        l.setText(label);
        Label sep = new Label(content, 258);
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        sep.setLayoutData((Object)d);
        for (ConfigurationModel m : model) {
            ExpandableComposite expand = new ExpandableComposite(content, 0);
            final ConfigurationDiff cd = new ConfigurationDiff((Composite)expand, 0, m.getModelType());
            d = new GridData();
            d.grabExcessHorizontalSpace = true;
            d.horizontalAlignment = 4;
            expand.setLayoutData((Object)d);
            expand.setLayout((Layout)new FillLayout());
            expand.setText(m.getCategoryName());
            expand.setClient((Control)cd);
            expand.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    cd.getShell().layout(true, true);
                }
            });
            cd.setModel(m);
            this.children.add(cd);
        }
        return content;
    }

    private Composite createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        Label l = new Label(header, 0);
        Label sep = new Label(header, 258);
        header.setLayout((Layout)new GridLayout(1, false));
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        sep.setLayoutData((Object)d);
        l.setText(Messages.getString(ConfigurationDiffList.class, "header.label"));
        return header;
    }

    private Composite createFooter(Composite parent) {
        Composite footer = new Composite(parent, 0);
        GridLayout l = new GridLayout(256, false);
        l.numColumns = 2;
        footer.setLayout((Layout)l);
        Label hsep = new Label(footer, 258);
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        d.horizontalSpan = 2;
        hsep.setLayoutData((Object)d);
        Label spacer = new Label(footer, 0);
        spacer.setVisible(false);
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        spacer.setLayoutData((Object)d);
        Button ok = new Button(footer, 0);
        ok.setText(Messages.getString(ConfigurationDiffList.class, "ok.button"));
        d = new GridData();
        d.verticalIndent = 10;
        ok.setLayoutData((Object)d);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigurationDiffList.this.onOk();
            }
        });
        return footer;
    }

    private void onOk() {
        ResultEvent re = new ResultEvent((Object)this, Result.Apply);
        for (ConfigurationDiffListener l : this.listeners) {
            l.onResult(re);
        }
    }
}

