/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.configuration.ui;

import com.ez.keeper.base.model.Field;
import com.ez.workspace.configuration.ui.ConfigurationModel;
import com.ez.workspace.configuration.ui.ModelType;
import com.ez.workspace.configuration.ui.PropertiesModel;
import com.ez.workspace.configuration.ui.TextModel;
import com.ez.workspace.configuration.ui.internal.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ConfigurationDiff
extends Composite {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    ConfigurationModel model;
    ContentImpl contentImpl;
    Label header;

    public ConfigurationDiff(Composite parent, int style, ModelType modelType) {
        super(parent, style);
        this.contentImpl = modelType.create(this);
        GridLayout l = new GridLayout(1, false);
        this.setLayout((Layout)l);
        Composite header = this.createHeader(this);
        GridData d = new GridData(4);
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        header.setLayoutData((Object)d);
        Composite content = this.createContent(this);
        d = new GridData(4);
        d.grabExcessVerticalSpace = true;
        d.verticalAlignment = 4;
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        content.setLayoutData((Object)d);
    }

    public void clearModel() {
        this.contentImpl.clear();
    }

    public void setModel(ConfigurationModel model) {
        String cn;
        this.model = model;
        if (this.model != null && (cn = this.model.getCategoryShortName()) != null) {
            this.header.setText(cn);
        }
    }

    public void populate() {
        if (this.contentImpl != null) {
            this.contentImpl.fillWidgets();
        }
    }

    private Composite createHeader(Composite parent) {
        Composite panes = new Composite(parent, 0);
        this.header = new Label(panes, 0);
        panes.setLayout((Layout)new RowLayout(256));
        return panes;
    }

    private Composite createContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout l = new GridLayout(2, false);
        content.setLayout((Layout)l);
        Composite panes = this.createDataComposite(content);
        if (panes != null) {
            GridData d = new GridData(4);
            d.grabExcessVerticalSpace = true;
            d.verticalAlignment = 4;
            d.grabExcessHorizontalSpace = true;
            d.horizontalAlignment = 4;
            panes.setLayoutData((Object)d);
        }
        return content;
    }

    private Composite createDataComposite(Composite parent) {
        return this.contentImpl.createWidgets(parent);
    }

    static abstract class ContentImpl {
        ContentImpl() {
        }

        abstract Composite createWidgets(Composite var1);

        abstract void fillWidgets();

        abstract void clear();
    }

    static class DirectoryContentImpl
    extends ContentImpl {
        ConfigurationDiff cd;

        DirectoryContentImpl(ConfigurationDiff cd) {
            this.cd = cd;
        }

        @Override
        Composite createWidgets(Composite parent) {
            return null;
        }

        @Override
        void fillWidgets() {
        }

        @Override
        void clear() {
        }
    }

    static class PropertiesContentImpl
    extends ContentImpl {
        Table table;
        ConfigurationDiff cd;
        private boolean showSpecialContent = false;

        PropertiesContentImpl(ConfigurationDiff cd, boolean showSpecialContent) {
            this.cd = cd;
            this.showSpecialContent = showSpecialContent;
        }

        @Override
        Composite createWidgets(Composite parent) {
            Composite panes = new Composite(parent, 0);
            panes.setLayout((Layout)new FillLayout());
            this.table = new Table(panes, 0);
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(Messages.getString(ConfigurationDiff.class, "property"));
            column = new TableColumn(this.table, 0);
            column.setText(Messages.getString(ConfigurationDiff.class, "local.value"));
            column = new TableColumn(this.table, 0);
            column.setText(Messages.getString(ConfigurationDiff.class, "server.value"));
            this.table.setHeaderVisible(true);
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                c.pack();
                ++n2;
            }
            this.table.setLinesVisible(true);
            this.table.layout(true);
            return panes;
        }

        @Override
        void fillWidgets() {
            String k;
            if (this.table == null) {
                throw new IllegalStateException("Widgets not created.");
            }
            this.table.clearAll();
            PropertiesModel m = (PropertiesModel)this.cd.model;
            Properties left = m != null ? m.getLeft() : null;
            Properties right = m != null ? m.getRight() : null;
            Map<Object, Object> lmap = Collections.emptyMap();
            Map<Object, Object> rmap = Collections.emptyMap();
            if (left != null) {
                lmap = m.isDisplaySorted() ? new TreeMap() : new HashMap();
                lmap.putAll(left);
            }
            if (right != null) {
                rmap = m.isDisplaySorted() ? new TreeMap() : new HashMap();
                rmap.putAll(right);
            }
            for (Map.Entry e : lmap.entrySet()) {
                k = (String)e.getKey();
                if (Field.isSpecialField((String)k)) continue;
                String lf = (String)e.getValue();
                String rv = rmap.containsKey(k) ? (String)rmap.get(k) : "";
                TableItem ti = new TableItem(this.table, 0);
                ti.setText(new String[]{k, PropertiesContentImpl.filterField(k, lf), PropertiesContentImpl.filterField(k, rv)});
            }
            for (Map.Entry e : rmap.entrySet()) {
                k = (String)e.getKey();
                if (Field.isSpecialField((String)k)) continue;
                String rv = (String)e.getValue();
                if (left != null && left.containsKey(k)) continue;
                TableItem ti = new TableItem(this.table, 0);
                ti.setText(new String[]{k, "", PropertiesContentImpl.filterField(k, rv)});
            }
        }

        static String filterField(String field, String value) {
            return Field.isPasswordField((String)field) ? PropertiesContentImpl.maskPassword(value) : value;
        }

        static String maskPassword(String fieldValue) {
            return fieldValue.replaceAll(".", "*");
        }

        @Override
        void clear() {
            if (this.table != null) {
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem i = tableItemArray[n2];
                    i.dispose();
                    ++n2;
                }
                Composite parent = this.table.getParent();
                this.table.dispose();
                this.table = null;
                parent.layout(true);
            }
        }
    }

    static class TextContentImpl
    extends ContentImpl {
        Text leftText;
        Text rightText;
        ConfigurationDiff cd;
        boolean showSpecialContent;

        TextContentImpl(ConfigurationDiff cd, boolean showSpecialContent) {
            this.cd = cd;
            this.showSpecialContent = showSpecialContent;
        }

        @Override
        Composite createWidgets(Composite parent) {
            Composite panes = new Composite(parent, 0);
            panes.setLayout((Layout)new GridLayout(2, false));
            Label ll = new Label(panes, 0);
            ll.setText(Messages.getString(ConfigurationDiff.class, "local.label"));
            ll.setVisible(true);
            Label rl = new Label(panes, 0);
            rl.setText(Messages.getString(ConfigurationDiff.class, "server.label"));
            rl.setVisible(true);
            this.leftText = new Text(panes, 2626);
            this.leftText.setEditable(false);
            GridData d = new GridData();
            d.verticalAlignment = 4;
            d.horizontalAlignment = 16384;
            d.widthHint = 500;
            d.grabExcessVerticalSpace = true;
            d.heightHint = 5 * this.leftText.getLineHeight();
            this.leftText.setLayoutData((Object)d);
            this.rightText = new Text(panes, 2626);
            this.rightText.setEditable(false);
            d = new GridData();
            d.verticalAlignment = 4;
            d.horizontalAlignment = 4;
            d.grabExcessHorizontalSpace = true;
            d.grabExcessVerticalSpace = true;
            d.widthHint = 500;
            d.heightHint = 5 * this.rightText.getLineHeight();
            this.rightText.setLayoutData((Object)d);
            return panes;
        }

        @Override
        void fillWidgets() {
            String right;
            if (this.leftText == null) {
                throw new IllegalStateException("Widgets not created.");
            }
            TextModel m = (TextModel)this.cd.model;
            String left = m != null ? m.getLeft() : null;
            String string = right = m != null ? m.getRight() : null;
            if (left != null) {
                this.leftText.setText(left);
            }
            if (right != null) {
                this.rightText.setText(right);
            }
        }

        @Override
        void clear() {
            if (this.leftText != null) {
                Composite parent = this.leftText.getParent();
                this.leftText.dispose();
                this.leftText = null;
                this.rightText.dispose();
                this.rightText = null;
                parent.layout(true);
            }
        }
    }
}

