/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.configuration;

import com.ez.eclient.configuration.synchro.service.Configuration;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.ConfigurationEvent;
import com.ez.eclient.configuration.synchro.service.ConfigurationFormat;
import com.ez.eclient.configuration.synchro.service.ConfigurationSynchroService;
import com.ez.eclient.configuration.synchro.service.ConfigurationVersionChanged;
import com.ez.eclient.configuration.synchro.service.JsonConfiguration;
import com.ez.eclient.configuration.synchro.service.SyncResolution;
import com.ez.eclient.configuration.synchro.service.VersionableProperties;
import com.ez.json.tools.converter.PropertiesConverter;
import com.ez.workspace.configuration.LogUtil;
import com.ez.workspace.configuration.ui.ConfigurationDialog;
import com.ez.workspace.configuration.ui.ConfigurationDiffListener;
import com.ez.workspace.configuration.ui.ConfigurationModel;
import com.ez.workspace.configuration.ui.ModelType;
import com.ez.workspace.configuration.ui.PropertiesModel;
import com.ez.workspace.configuration.ui.ResultEvent;
import com.ez.workspace.configuration.ui.internal.Messages;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesNotifyJob
extends Job {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final Logger L = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    final List<ConfigurationEvent> events;

    public PropertiesNotifyJob(List<ConfigurationEvent> events) {
        super(Messages.getString(PropertiesNotifyJob.class, "confirm.job"));
        this.events = events;
    }

    public IStatus run(IProgressMonitor monitor) {
        if (this.events.size() > 0) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PropertiesNotifyJob.this.showPopup();
                }
            });
        }
        return Status.OK_STATUS;
    }

    void showPopup() {
        Shell parentShell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        final Shell shell = new Shell(parentShell, 65648);
        ConfigurationDialog dialog = new ConfigurationDialog(shell, 0);
        Display display = parentShell.getDisplay();
        int i = 0;
        for (ConfigurationEvent e : this.events) {
            ConfigurationModel cm = null;
            Configuration current = e.getCurrent();
            Configuration other = e.getOther();
            ConfigurationDescription cd = e.getConfigurationDescription();
            ConfigurationFormat f = cd.getFormat();
            if (f == ConfigurationFormat.Properties || f == ConfigurationFormat.EnhancedProperties) {
                cm = new PropertiesModel(cd.getCategoryShortName(), cd.getCategoryName(), cd.isHotSwappable(), (Properties)((VersionableProperties)current), (Properties)((VersionableProperties)other), false);
            } else if (f == ConfigurationFormat.Json) {
                String ldata = ((JsonConfiguration)current).getData();
                String rdata = ((JsonConfiguration)other).getData();
                cm = new PropertiesModel(cd.getCategoryShortName(), cd.getCategoryName(), cd.isHotSwappable(), this.jsonToProperties(ldata), this.jsonToProperties(rdata), true);
            } else if (f == ConfigurationFormat.Directory) {
                cm = new ConfigurationModel(ModelType.Directory, cd.getCategoryShortName(), cd.getCategoryName(), cd.isHotSwappable());
            } else {
                throw new RuntimeException("Type not implemented: " + f);
            }
            if (cm == null) continue;
            ++i;
            dialog.addModel(cm);
        }
        if (i > 0) {
            dialog.populate();
            dialog.addResultListener(new ConfigurationDiffListener(){

                @Override
                public void onResult(ResultEvent event) {
                    shell.close();
                }
            });
            shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    PropertiesNotifyJob.this.popupClosed();
                }
            });
            shell.setText(Messages.getString(PropertiesNotifyJob.class, "shell.config.changed"));
            shell.setLayout((Layout)new FillLayout());
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private Properties jsonToProperties(String data) {
        JsonStructure s;
        Properties p = null;
        if (data != null && (s = this.parseJson(data)) != null) {
            p = this.jsonToProps(s);
        }
        if (p == null) {
            p = new Properties();
        }
        return p;
    }

    private JsonStructure parseJson(String data) {
        JsonStructure s = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (JsonReader r = Json.createReader((Reader)new StringReader(data));){
            try {
                s = r.read();
            }
            catch (Exception ex) {
                this.L.error("Can't parse JSON: {}", (Object)data, (Object)ex);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return s;
    }

    private Properties jsonToProps(JsonStructure o) {
        Properties p = new Properties();
        try {
            PropertiesConverter.writeToProperties((JsonStructure)o, (Properties)p);
        }
        catch (Exception ex) {
            this.L.error("Can't convert to properties: {}", (Object)o, (Object)ex);
        }
        return p;
    }

    void popupClosed() {
        try {
            for (ConfigurationEvent e : this.events) {
                ConfigurationDescription cd = e.getConfigurationDescription();
                ConfigurationSynchroService service = e.getService();
                if (cd.isHotSwappable()) {
                    try {
                        service.resolveSync(cd.getUniqueId(), SyncResolution.Apply, e.getCurrentConfigId(), e.getCurrent().getVersion(), e.getOtherConfigId(), e.getOther().getVersion());
                        LogUtil.log(1, Messages.getString(PropertiesNotifyJob.class, "log.config.update.asap", new String[]{cd.getUniqueId()}));
                    }
                    catch (ConfigurationVersionChanged ex) {
                        this.L.error("Version changed.", (Throwable)ex);
                        LogUtil.log(2, Messages.getString(PropertiesNotifyJob.class, "log.config.warning.postponed", new String[]{cd.getUniqueId()}));
                    }
                    continue;
                }
                try {
                    service.resolveSync(cd.getUniqueId(), SyncResolution.Postpone, e.getCurrentConfigId(), e.getCurrent().getVersion(), e.getOtherConfigId(), e.getOther().getVersion());
                    LogUtil.log(1, Messages.getString(PropertiesNotifyJob.class, "log.config.update.nxt.startup", new String[]{cd.getUniqueId()}));
                }
                catch (ConfigurationVersionChanged ex) {
                    this.L.error("Version changed.", (Throwable)ex);
                    LogUtil.log(2, Messages.getString(PropertiesNotifyJob.class, "log.config.warning.postponed", new String[]{cd.getUniqueId()}));
                }
            }
        }
        catch (Exception ex) {
            this.L.error("Unexpected error.", (Throwable)ex);
        }
    }
}

