/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.configuration;

import com.ez.eclient.configuration.bootstrap.BootstrapParticipant;
import com.ez.eclient.configuration.bootstrap.Bootstrapper;
import com.ez.eclient.configuration.synchro.service.ConfigurationEvent;
import com.ez.eclient.configuration.synchro.service.ConfigurationListener;
import com.ez.eclient.configuration.synchro.service.EventType;
import com.ez.workspace.configuration.LogUtil;
import com.ez.workspace.configuration.PropertiesNotifyJob;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ConfigurationEventConfigurator
implements BootstrapParticipant {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public void preConfigure(Properties properties) {
    }

    public void postConfigure(Bootstrapper bs) {
        bs.registerListener(new ConfigurationListener(){

            public void notifyEvent(List<ConfigurationEvent> e) {
                ConfigurationEventConfigurator.this.onEvent(e);
            }
        });
    }

    private void onEvent(List<ConfigurationEvent> el) {
        LinkedList<ConfigurationEvent> newVersionList = new LinkedList<ConfigurationEvent>();
        for (ConfigurationEvent e : el) {
            if (e.getType() == EventType.SyncAvailable) {
                newVersionList.add(e);
                continue;
            }
            LogUtil.log(1, String.format("Configuration update for %s applied.", e.getConfigurationDescription().getUniqueId()));
        }
        if (!newVersionList.isEmpty()) {
            PropertiesNotifyJob job = new PropertiesNotifyJob(newVersionList);
            job.setRule(SingletonRule.INST);
            job.schedule();
        }
    }

    private static class SingletonRule
    implements ISchedulingRule {
        public static final SingletonRule INST = new SingletonRule();

        private SingletonRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

