/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.idz.data.source.gui;

import com.ez.rdz.resources.mainframe.analysis.RDZMainframeAnalysisJob;
import com.ez.rdz.resources.mainframe.analysis.SQLTableIdentifier;
import com.ez.rdz.utils.Messages;
import com.ibm.datatools.db2.zseries.catalog.ZSeriesCatalogTable;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataSourceHandler
extends AbstractHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GetDataSourceHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LinkedHashSet<SQLTableIdentifier> rdzResourceIdentifiers = new LinkedHashSet<SQLTableIdentifier>();
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection currentSelection = (IStructuredSelection)selection;
            for (Object item : currentSelection) {
                L.debug("\t------> {}", item.getClass());
                if (!(item instanceof ZSeriesCatalogTable)) continue;
                ZSeriesCatalogTable table = (ZSeriesCatalogTable)item;
                String tableName = table.getName();
                String connName = table.getConnection().toString();
                rdzResourceIdentifiers.add(new SQLTableIdentifier(tableName, "SQL Table", connName));
            }
        }
        if (rdzResourceIdentifiers.size() == 0) {
            MessageDialog.openInformation((Shell)Display.getDefault().getShells()[0], (String)Messages.getString(GetDataSourceHandler.class, (String)"messageDialog.result.title"), (String)Messages.getString(GetDataSourceHandler.class, (String)"messageDialog.result.msg"));
        } else {
            new RDZMainframeAnalysisJob(Messages.getString(GetDataSourceHandler.class, (String)"job.rdzAnalysis.name"), rdzResourceIdentifiers).schedule();
        }
        return null;
    }
}

